/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.messages;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public class Messages {
    private static ResourceBundle resourceBundleValidation;
    private static ResourceBundle resourceBundleError;
    private static ResourceBundle resourceBundleMessages;
    private static String DATE_FORMAT;

    public static String getValidationMsg(String codeMessage, Object ... adicional) {
        if (codeMessage == null) {
            return null;
        }
        ResourceBundle msg = Messages.getResourceBundleValidation();
        ResourceBundle msgError = Messages.getResourceBundleErrors();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        if (msgError.containsKey(codeMessage)) {
            String ret = msgError.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getErrorMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = Messages.getResourceBundleErrors();
        if (codeMessage == null) {
            return "codemessage can't be null";
        }
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            Object[] data = Messages.processFormattData(adicional);
            ret = MessageFormat.format(ret, data);
            return ret;
        }
        return codeMessage;
    }

    public static String getMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = Messages.getResourceBundleMessages();
        if (codeMessage == null) {
            return "codemessage can't be null";
        }
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            Object[] data = Messages.processFormattData(adicional);
            ret = MessageFormat.format(ret, data);
            return ret;
        }
        return codeMessage;
    }

    private static Object[] processFormattData(Object[] adicional) {
        if (adicional == null) {
            return null;
        }
        Object[] ret = new Object[adicional.length];
        for (int i = 0; i < adicional.length; ++i) {
            Object temp = adicional[i];
            if (temp instanceof Double || temp instanceof Float) {
                temp = Messages.formatNumber((Number)temp, 2);
            } else if (temp instanceof Date) {
                temp = Messages.formatDate((Date)temp);
            }
            ret[i] = temp == null ? "null" : temp;
        }
        return ret;
    }

    private static Object formatDate(Date temp) {
        SimpleDateFormat s = new SimpleDateFormat(DATE_FORMAT);
        return s.format(temp);
    }

    private static Object formatNumber(Number temp, int i) {
        return String.format("%." + i + "f", temp.doubleValue());
    }

    public static ResourceBundle getResourceBundleValidation() {
        if (resourceBundleValidation == null) {
            resourceBundleValidation = ResourceBundle.getBundle("com/touchcomp/basementorbanks/messages/bank_validation", Locale.getDefault());
        }
        return resourceBundleValidation;
    }

    public static ResourceBundle getResourceBundleErrors() {
        if (resourceBundleError == null) {
            resourceBundleError = ResourceBundle.getBundle("com/touchcomp/basementorbanks/messages/bank_errors", Locale.getDefault());
        }
        return resourceBundleError;
    }

    public static ResourceBundle getResourceBundleMessages() {
        if (resourceBundleError == null) {
            resourceBundleError = ResourceBundle.getBundle("com/touchcomp/basementorbanks/messages/bank_messages", Locale.getDefault());
        }
        return resourceBundleError;
    }

    public static Object[] translateData(String[] data) {
        Object[] processed = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            processed[i] = Messages.getMsg(data[i], new Object[0]);
        }
        return processed;
    }

    static {
        DATE_FORMAT = "dd/MM/yyyy hh:mm:ss";
    }
}

