/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.model;

import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.interfaces.ResultInterface;
import com.touchcomp.basementorbanks.util.UtilDate;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class BankToken
implements ResultInterface {
    private BankCredentials bankCredentials;
    private String token;
    private Date expiresIn;
    private String tokenType;

    private BankToken() {
    }

    public BankToken(BankCredentials bankCredentials) {
        this.bankCredentials = bankCredentials;
    }

    public boolean isExpired() {
        return this.expiresIn == null || this.expiresIn.before(new Date());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("token", (Object)this.token).append("expires", (Object)UtilDate.dateToStr(this.expiresIn, UtilDate.Mask.TRACE_FORMATTER)).toString();
    }

    @Generated
    public BankCredentials getBankCredentials() {
        return this.bankCredentials;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public Date getExpiresIn() {
        return this.expiresIn;
    }

    @Generated
    public String getTokenType() {
        return this.tokenType;
    }

    @Generated
    public void setBankCredentials(BankCredentials bankCredentials) {
        this.bankCredentials = bankCredentials;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setExpiresIn(Date expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Generated
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankToken)) {
            return false;
        }
        BankToken other = (BankToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BankCredentials this$bankCredentials = this.getBankCredentials();
        BankCredentials other$bankCredentials = other.getBankCredentials();
        if (this$bankCredentials == null ? other$bankCredentials != null : !((Object)this$bankCredentials).equals(other$bankCredentials)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Date this$expiresIn = this.getExpiresIn();
        Date other$expiresIn = other.getExpiresIn();
        if (this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn)) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        return !(this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BankToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BankCredentials $bankCredentials = this.getBankCredentials();
        result = result * 59 + ($bankCredentials == null ? 43 : ((Object)$bankCredentials).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Date $expiresIn = this.getExpiresIn();
        result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        return result;
    }
}

