/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.model;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.constants.ResultStatusType;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.model.interfaces.ParamsInterface;
import com.touchcomp.basementorbanks.model.interfaces.ResultInterface;

public class ProcessResult<P extends ParamsInterface, R extends ResultInterface> {
    private P params;
    private R result;
    private ResponseResult response;
    private ResultStatusType status = ResultStatusType.OK;
    private ConstraintViolations contraintValidation;

    private ProcessResult() {
    }

    public ProcessResult(ResultStatusType status) {
        this();
        this.status = status;
    }

    public ProcessResult(P params, ConstraintViolations contraintValidation) {
        this();
        this.params = params;
        this.status = ResultStatusType.ERROR_VALIDATION;
        this.contraintValidation = contraintValidation;
    }

    public ProcessResult(P params, R result, ResponseResult pr) {
        this();
        this.status = pr.isOk() ? ResultStatusType.OK : ResultStatusType.ERROR;
        this.params = params;
        this.result = result;
        this.response = pr;
    }

    public ProcessResult(ResponseResult pr) {
        this();
        this.status = pr.isOk() ? ResultStatusType.OK : ResultStatusType.ERROR;
        this.response = pr;
    }

    public P getParams() {
        return this.params;
    }

    public void setParams(P params) {
        this.params = params;
    }

    public R getResult() {
        return this.result;
    }

    public void setResult(R result) {
        this.result = result;
    }

    public ConstraintViolations getContraintValidation() {
        return this.contraintValidation;
    }

    public void setContraintValidation(ConstraintViolations contraintValidation) {
        this.contraintValidation = contraintValidation;
    }

    public ResultStatusType getStatus() {
        return this.status;
    }

    public void setStatus(ResultStatusType status) {
        this.status = status;
    }

    public ResponseResult getResponse() {
        return this.response;
    }

    public void setResponse(ResponseResult response) {
        this.response = response;
    }

    public boolean isOk() {
        return this.getResponse() != null && this.getResponse().isOk();
    }
}

