/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.model;

import com.touchcomp.basementorbanks.model.ResultItem;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import okhttp3.Response;

public class ResponseResult {
    private int statusResponseCode = 200;
    private String body;
    private List<ResultItem> errors = new LinkedList<ResultItem>();

    public ResponseResult(Response response) throws IOException {
        if (response != null) {
            this.statusResponseCode = response.code();
            this.body = response.body() != null ? response.body().string() : null;
        }
    }

    public boolean isOk() {
        return this.statusResponseCode >= 200 && this.statusResponseCode <= 299;
    }

    public List<ResultItem> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ResultItem> errors) {
        this.errors = errors;
    }

    public String getErrorsAsString() {
        StringBuilder sb = new StringBuilder();
        for (ResultItem error : this.errors) {
            sb.append(error.getCode()).append(": ").append(error.getDescription());
        }
        return sb.toString();
    }

    @Generated
    public int getStatusResponseCode() {
        return this.statusResponseCode;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public void setStatusResponseCode(int statusResponseCode) {
        this.statusResponseCode = statusResponseCode;
    }

    @Generated
    public void setBody(String body) {
        this.body = body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseResult)) {
            return false;
        }
        ResponseResult other = (ResponseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatusResponseCode() != other.getStatusResponseCode()) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        List<ResultItem> this$errors = this.getErrors();
        List<ResultItem> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResponseResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatusResponseCode();
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        List<ResultItem> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResponseResult(statusResponseCode=" + this.getStatusResponseCode() + ", body=" + this.getBody() + ", errors=" + String.valueOf(this.getErrors()) + ")";
    }
}

