/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services;

import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.util.UtilDate;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class BankJsonConverter {
    public JsonNode getRoot(String json) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(json);
            return root;
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    public Double asDouble(JsonNode rootNode, String key) {
        JsonNode node = rootNode.findValue(key);
        if (node == null) {
            return 0.0;
        }
        return node.asDouble();
    }

    public Integer asInt(JsonNode rootNode, String key) {
        JsonNode node = rootNode.findValue(key);
        if (node == null) {
            return 0;
        }
        return node.asInt();
    }

    public String asText(JsonNode rootNode, String key) {
        JsonNode node = rootNode.findValue(key);
        if (node == null || String.valueOf("null").equalsIgnoreCase(node.asText())) {
            return null;
        }
        return node.asText();
    }

    public Date asDate(JsonNode rootNode, String key, UtilDate.Mask mask) {
        String text = this.asText(rootNode, key);
        if (text == null || String.valueOf(text).equals("null")) {
            return null;
        }
        return UtilDate.strToDate(text, mask);
    }

    public LocalDate asLocalDate(JsonNode rootNode, String key, UtilDate.Mask mask) {
        String text = this.asText(rootNode, key);
        if (text == null || String.valueOf(text).equals("null")) {
            return null;
        }
        if (text.length() > mask.getDateMask().length()) {
            text = text.substring(0, mask.getDateMask().length());
        }
        return UtilDate.strToLocalDate(text, mask);
    }

    public LocalDateTime asLocalDateTime(JsonNode rootNode, String key) {
        String text = this.asText(rootNode, key);
        if (text == null || String.valueOf(text).equals("null")) {
            return null;
        }
        return UtilDate.strToLocalDateTime(text);
    }

    public boolean asBoolean(JsonNode rootNode, String key) {
        JsonNode node = rootNode.findValue(key);
        if (node == null) {
            return false;
        }
        return node.asBoolean();
    }

    public List<String> asStringList(JsonNode rootNode, String key) {
        LinkedList<String> r = new LinkedList<String>();
        List ret = rootNode.findValues(key);
        for (JsonNode jsonNode : ret) {
            if (jsonNode.isArray()) {
                for (JsonNode jsonNode1 : jsonNode) {
                    r.add(jsonNode1.asText());
                }
                continue;
            }
            r.add(jsonNode.asText());
        }
        return r;
    }

    public List<JsonNode> asList(JsonNode node, String key) {
        List content = node.findValues(key);
        LinkedList<JsonNode> temp = new LinkedList<JsonNode>();
        if (content == null) {
            return temp;
        }
        for (JsonNode jsonNode : content) {
            if (jsonNode.isArray()) {
                for (JsonNode aux : jsonNode) {
                    temp.add(aux);
                }
                continue;
            }
            temp.add(jsonNode);
        }
        return temp;
    }
}

