/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.connection;

import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankValidationException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.model.ResultItem;
import com.touchcomp.basementorbanks.services.BankBaseConnection;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.util.UtilDate;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class SantanderBaseConnection
extends BankBaseConnection {
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    private final String GRANT_TYPE = "grant_type";
    private final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private BankJsonConverter converter = new BankJsonConverter();

    private RequestBody body(String bodyStr) {
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)bodyStr, (MediaType)mediaType);
        return body;
    }

    private Request.Builder request(BankToken token, String url) {
        Request.Builder request = new Request.Builder();
        request.addHeader("Content-Type", "application/json").url(url).addHeader("Accept", "application/json").addHeader("Authorization", "Bearer " + token.getToken()).addHeader("X-Application-Key", token.getBankCredentials().getParamsString(CLIENT_ID));
        return request;
    }

    public ResponseResult exchangeGetData(BankToken token, String url) throws BankException {
        try {
            Response response = this.httpClient(token.getBankCredentials()).newCall(this.request(token, url).build()).execute();
            return this.checkForException(response);
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    public ResponseResult exchangePostData(BankToken token, String url, String entity) throws BankException {
        try {
            Response response = this.httpClient(token.getBankCredentials()).newCall(this.request(token, url).post(this.body(entity)).build()).execute();
            return this.checkForException(response);
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    public ResponseResult exchangePutData(BankToken token, String url, String entity) throws BankException {
        try {
            Response response = this.httpClient(token.getBankCredentials()).newCall(this.request(token, url).put(this.body(entity)).build()).execute();
            return this.checkForException(response);
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    public ResponseResult exchangePatchData(BankToken token, String url, String entity) throws BankException {
        try {
            Response response = this.httpClient(token.getBankCredentials()).newCall(this.request(token, url).patch(this.body(entity)).build()).execute();
            return this.checkForException(response);
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    public ResponseResult exchangeDeleteData(BankToken token, String url) throws BankException {
        try {
            Response response = this.httpClient(token.getBankCredentials()).newCall(this.request(token, url).delete().build()).execute();
            return this.checkForException(response);
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    public ResponseResult exchangeDeleteData(BankToken token, String url, String entity) throws BankException {
        try {
            Response response = this.httpClient(token.getBankCredentials()).newCall(this.request(token, url).delete(this.body(entity)).build()).execute();
            return this.checkForException(response);
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials, String urlAuth) throws BankException {
        try {
            String clientId = credentials.getParamsString(CLIENT_ID);
            String clientSecret = credentials.getParamsString(CLIENT_SECRET);
            String grantType = credentials.getParamsString("grant_type");
            if (clientSecret == null || clientSecret.length() == 0) {
                throw new BankException("E.BANK.000019");
            }
            if (clientId == null || clientId.length() == 0) {
                throw new BankException("E.BANK.000018");
            }
            if (grantType == null) {
                grantType = "client_credentials";
            }
            FormBody formBody = new FormBody.Builder().add(CLIENT_ID, clientId).add(CLIENT_SECRET, clientSecret).add("grant_type", grantType).build();
            Request request = new Request.Builder().url(urlAuth).post((RequestBody)formBody).build();
            Response response = this.httpClient(credentials).newCall(request).execute();
            ResponseResult pr = this.checkForException(response);
            if (pr.isOk()) {
                BankToken token = this.convertTextBankToken(pr.getBody(), credentials);
                return new ProcessResult<BankCredentials, BankToken>(credentials, token, pr);
            }
            return new ProcessResult<BankCredentials, BankToken>(pr);
        }
        catch (Exception ex) {
            if (ex.getMessage() != null && ex.getMessage().contains("PKIX path building")) {
                throw new BankException("E.BANK.000008", ex);
            }
            throw new BankException(ex);
        }
    }

    private BankToken convertTextBankToken(String json, BankCredentials credentials) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            BankToken aux = new BankToken(credentials);
            JsonNode jsonNode = mapper.readTree(json);
            String token = jsonNode.findValue("access_token").getTextValue();
            Integer expires = jsonNode.findValue("expires_in").getIntValue();
            String tokenType = jsonNode.findValue("token_type").getTextValue();
            aux.setToken(token);
            aux.setTokenType(tokenType);
            aux.setExpiresIn(UtilDate.nextDateBySeconds(new Date(), expires));
            return aux;
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    protected void checkAuth(BankToken auth) {
        if (!UtilMethods.isWithData(auth.getToken())) {
            throw new BankValidationException("token");
        }
        if (!UtilMethods.isWithData((Object)auth.getBankCredentials().getEnvironmentType())) {
            throw new BankValidationException("environmentType");
        }
    }

    private ResponseResult checkForException(Response response) throws BankException, IOException {
        ResponseResult res = new ResponseResult(response);
        if (res.isOk()) {
            return res;
        }
        if (res.getStatusResponseCode() >= 400 && res.getStatusResponseCode() <= 499) {
            List<ResultItem> itens = this.convertErrors(res.getBody());
            res.setErrors(itens);
            return res;
        }
        throw new BankException("E.BANK.000014", String.valueOf(res.getStatusResponseCode()), res.getBody());
    }

    private List<ResultItem> convertErrors(String body) throws BankException {
        LinkedList<ResultItem> itens = new LinkedList<ResultItem>();
        if (!UtilMethods.isStrWithData(body)) {
            return itens;
        }
        JsonNode root = this.converter.getRoot(body);
        if (root.get("error") != null) {
            ResultItem item = new ResultItem(this.converter.asText(root, "error"));
            if (root.get("error_description") != null) {
                item.setDescription(this.converter.asText(root, "error_description"));
            }
            itens.add(item);
        }
        if (root.get("_errors") != null) {
            for (JsonNode nodeError : this.converter.asList(root, "_errors")) {
                ResultItem item = new ResultItem(this.converter.asText(nodeError, "_code"));
                item.setDescription(this.converter.asText(nodeError, "_message"));
                itens.add(item);
            }
        }
        return itens;
    }
}

