/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.accounts;

import com.touchcomp.basementorbanks.constants.BankType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankNotSupportedException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.services.impl.accounts.AccountsInterface;
import com.touchcomp.basementorbanks.services.impl.accounts.impl.santander.SantanderAccountsImpl;
import com.touchcomp.basementorbanks.services.impl.accounts.model.Accounts;
import com.touchcomp.basementorbanks.services.impl.accounts.model.AccountsParams;

public class BankAccounts {
    public ProcessResult<AccountsParams, Accounts> getAccounts(AccountsParams params) throws BankException, BankNotSupportedException {
        AccountsInterface found = this.get(params.getToken().getBankCredentials());
        return found.getAccounts(params);
    }

    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials crendentials) throws BankException, BankNotSupportedException {
        AccountsInterface found = this.get(crendentials);
        return found.getToken(crendentials);
    }

    private AccountsInterface get(BankCredentials credentials) throws BankNotSupportedException {
        BankType type = credentials.getBankType();
        switch (type) {
            case SANTANDER: {
                return new SantanderAccountsImpl();
            }
        }
        throw new BankNotSupportedException(type.toString());
    }
}

