/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.accounts.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.accounts.AccountsURL;
import com.touchcomp.basementorbanks.services.impl.accounts.model.AccountsParams;
import com.touchcomp.basementorbanks.url.AccountURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UtilMethods;

public class AccountsURLConverterImpl
implements AccountsURL {
    private AccountURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getAccountsURL();
        }
        return new SantanderHomoURL().getAccountsURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getAccountsUrl(AccountsParams params) {
        String url = UtilMethods.formatMessage(this.getUrl(params.getToken().getBankCredentials().getEnvironmentType()).getAccountUrl(), params.getBankNumber().getCode());
        return url;
    }
}

