/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.accounts.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.accounts.AccountsConverter;
import com.touchcomp.basementorbanks.services.impl.accounts.model.Accounts;
import java.util.LinkedList;
import org.codehaus.jackson.JsonNode;

public class SantanderAccountsConverter
extends BankJsonConverter
implements AccountsConverter {
    @Override
    public Accounts textToAccounts(String json, EnvironmentType environmentType) throws BankException {
        Accounts ret = new Accounts();
        JsonNode jsonNode = this.getRoot(json);
        JsonNode content = jsonNode.findValue("_content");
        if (content == null) {
            return ret;
        }
        LinkedList<Accounts.Account> data = new LinkedList<Accounts.Account>();
        for (JsonNode account : content) {
            String bank = this.asText(account, "compeCode");
            String branch = this.asText(account, "branchCode");
            String number = this.asText(account, "number");
            data.add(new Accounts.Account(bank, branch, number));
        }
        ret.setAccounts(data);
        return ret;
    }
}

