/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.accounts.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.accounts.AccountsConverter;
import com.touchcomp.basementorbanks.services.impl.accounts.AccountsInterface;
import com.touchcomp.basementorbanks.services.impl.accounts.AccountsValid;
import com.touchcomp.basementorbanks.services.impl.accounts.impl.santander.AccountsURLConverterImpl;
import com.touchcomp.basementorbanks.services.impl.accounts.impl.santander.SantanderAccountsConverter;
import com.touchcomp.basementorbanks.services.impl.accounts.impl.santander.SantanderValidAccountsImpl;
import com.touchcomp.basementorbanks.services.impl.accounts.model.Accounts;
import com.touchcomp.basementorbanks.services.impl.accounts.model.AccountsParams;

public class SantanderAccountsImpl
extends SantanderBaseConnection
implements AccountsInterface {
    private final AccountsConverter converter = new SantanderAccountsConverter();
    private final AccountsURLConverterImpl urlConverter = new AccountsURLConverterImpl();
    private final AccountsValid validator = new SantanderValidAccountsImpl();

    @Override
    public ProcessResult<AccountsParams, Accounts> getAccounts(AccountsParams params) throws BankException {
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getAccountsUrl(params);
            Accounts ret = null;
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToAccounts(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<AccountsParams, Object>(params, ret, res);
        }
        return new ProcessResult<AccountsParams, Accounts>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        String url = this.urlConverter.getAuthUrl(credentials);
        return this.getToken(credentials, url);
    }
}

