/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.balance;

import com.touchcomp.basementorbanks.constants.BankType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankNotSupportedException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.services.impl.balance.BalanceInterface;
import com.touchcomp.basementorbanks.services.impl.balance.impl.santander.SantanderBalanceImpl;
import com.touchcomp.basementorbanks.services.impl.balance.model.Balance;
import com.touchcomp.basementorbanks.services.impl.balance.model.BalanceParams;

public class BankBalance {
    public ProcessResult<BalanceParams, Balance> getAccounts(BalanceParams params) throws BankException, BankNotSupportedException {
        BalanceInterface found = this.get(params.getToken().getBankCredentials());
        return found.getBalance(params);
    }

    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials crendentials) throws BankException, BankNotSupportedException {
        BalanceInterface found = this.get(crendentials);
        return found.getToken(crendentials);
    }

    private BalanceInterface get(BankCredentials credentials) throws BankNotSupportedException {
        BankType type = credentials.getBankType();
        switch (type) {
            case SANTANDER: {
                return new SantanderBalanceImpl();
            }
        }
        throw new BankNotSupportedException(type.toString());
    }
}

