/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.balance.impl.santander;

import com.touchcomp.basementorbanks.constants.CurrencyType;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.balance.BalanceConverter;
import com.touchcomp.basementorbanks.services.impl.balance.model.Balance;
import org.codehaus.jackson.JsonNode;

public class SantanderBalanceConverter
extends BankJsonConverter
implements BalanceConverter {
    @Override
    public Balance textToBalance(String json, EnvironmentType environmentType) throws BankException {
        JsonNode root = this.getRoot(json);
        Double availableAmount = this.asDouble(root, "availableAmount");
        String availableAmountCurrency = this.asText(root, "availableAmountCurrency");
        Double blockedAmount = this.asDouble(root, "blockedAmount");
        String blockedAmountCurrency = this.asText(root, "blockedAmountCurrency");
        Double automaticallyInvestedAmount = this.asDouble(root, "automaticallyInvestedAmount");
        String automaticallyInvestedAmountCurrency = this.asText(root, "automaticallyInvestedAmountCurrency");
        Balance aux = new Balance();
        aux.setAutomaticallyInvestedAmount(automaticallyInvestedAmount);
        aux.setAvailableAmount(availableAmount);
        aux.setBlockedAmount(blockedAmount);
        aux.setAutomaticallyInvestedAmountCurrency(CurrencyType.get(automaticallyInvestedAmountCurrency));
        aux.setAvailableAmountCurrency(CurrencyType.get(availableAmountCurrency));
        aux.setBlockedAmountCurrency(CurrencyType.get(blockedAmountCurrency));
        return aux;
    }
}

