/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.balance.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.balance.BalanceConverter;
import com.touchcomp.basementorbanks.services.impl.balance.BalanceInterface;
import com.touchcomp.basementorbanks.services.impl.balance.BalanceURL;
import com.touchcomp.basementorbanks.services.impl.balance.BalanceValid;
import com.touchcomp.basementorbanks.services.impl.balance.impl.santander.SantanderBalanceConverter;
import com.touchcomp.basementorbanks.services.impl.balance.impl.santander.SantanderBalanceURLConverterImpl;
import com.touchcomp.basementorbanks.services.impl.balance.impl.santander.SantanderBalanceValidImpl;
import com.touchcomp.basementorbanks.services.impl.balance.model.Balance;
import com.touchcomp.basementorbanks.services.impl.balance.model.BalanceParams;

public class SantanderBalanceImpl
extends SantanderBaseConnection
implements BalanceInterface {
    private final BalanceConverter converter = new SantanderBalanceConverter();
    private final BalanceURL urlConverter = new SantanderBalanceURLConverterImpl();
    private final BalanceValid validator = new SantanderBalanceValidImpl();

    @Override
    public ProcessResult<BalanceParams, Balance> getBalance(BalanceParams params) throws BankException {
        Balance ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getBalanceUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            ret = this.converter.textToBalance(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            return new ProcessResult<BalanceParams, Balance>(params, ret, res);
        }
        return new ProcessResult<BalanceParams, Balance>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        String url = this.urlConverter.getAuthUrl(credentials);
        return this.getToken(credentials, url);
    }
}

