/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.balance.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.balance.BalanceURL;
import com.touchcomp.basementorbanks.services.impl.balance.model.BalanceParams;
import com.touchcomp.basementorbanks.url.BalanceURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UtilMethods;

public class SantanderBalanceURLConverterImpl
implements BalanceURL {
    private BalanceURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getBalanceURL();
        }
        return new SantanderHomoURL().getBalanceURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getBalanceUrl(BalanceParams params) {
        String url = UtilMethods.formatMessage(this.getUrl(params.getToken().getBankCredentials().getEnvironmentType()).getBalanceUrl(), params.getBranchNumber(), params.getAccountNumber());
        return url;
    }
}

