/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.pix.impl.santander;

import com.touchcomp.basementorbanks.constants.DocumentType;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.billing.pix.PixBillingURL;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.PixListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDueCancelParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDueListParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDueParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNowCancelParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNowListParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNowParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixreturn.PixReturnListParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixreturn.PixReturnParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixCancelParam;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixListAllParam;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixListParam;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixParam;
import com.touchcomp.basementorbanks.url.PixURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilDate;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Objects;
import java.util.Optional;

public class SantanderPixBillingURLImpl
implements PixBillingURL {
    private PixURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getPixURL();
        }
        return new SantanderHomoURL().getPixURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getCreatePixNowUrl(PixNowParams params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getCreationPixNow(), params.getPixId());
    }

    @Override
    public String getCancelPixNowUrl(PixNowCancelParams params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getDeletePixNow(), params.getPixId());
    }

    @Override
    public String getListPixNowUrl(PixNowListParams params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getListPixNow(), params.getPixId());
    }

    @Override
    public String getCreatePixDueUrl(PixDueParams params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getCreationPixDue(), params.getPixId());
    }

    @Override
    public String getCancelPixDueUrl(PixDueCancelParams params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getDeletePixDue(), params.getPixId());
    }

    @Override
    public String getListPixDueUrl(PixDueListParams params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getListPixDue(), params.getPixId(), params.getRevision());
    }

    @Override
    public String getListAllUrl(PixListAllParams params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getPixListAll(), new Object[0]);
        UriComponentsBuilder builder = UriComponentsBuilder.from(url).queryParamIfPresent("paginacao.itensPorPagina", Optional.ofNullable(params.getOffset())).queryParamIfPresent("paginacao.paginaAtual", Optional.ofNullable(params.getPage())).queryParamIfPresent("inicio", Optional.ofNullable(UtilDate.dateToStr(params.getInitialDate(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("fim", Optional.ofNullable(UtilDate.dateToStr(params.getFinalDate(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("txid", Optional.ofNullable(params.getTransactionPixId()));
        if (Objects.equals((Object)DocumentType.CNPJ, (Object)params.getDocumentType())) {
            builder.queryParamIfPresent("cnpj", Optional.ofNullable(params.getDocument()));
        } else {
            builder.queryParamIfPresent("cpf", Optional.ofNullable(params.getDocument()));
        }
        return builder.build();
    }

    @Override
    public String getAskReturnUrl(PixReturnParams params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getAskReturn(), params.getEndToEndTransaction(), params.getReturnTransactionId());
    }

    @Override
    public String getListPixReturnUrl(PixReturnListParams params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getListAskReturn(), params.getEndToEndTransaction(), params.getReturnTransactionId());
    }

    @Override
    public String getCreateWebhookUrl(WebhookPixParam params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getCreationWebhook(), params.getDictKey());
    }

    @Override
    public String getCancelWebhookUrl(WebhookPixCancelParam params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getDeletePixWebhook(), params.getDictKey());
    }

    @Override
    public String getListWebHookUrl(WebhookPixListParam params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(source.getPixWebhookList(), params.getDictKey());
    }

    @Override
    public String getListAllWebhookUrl(WebhookPixListAllParam params) {
        PixURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getPixWebhookListAll(), new Object[0]);
        return UriComponentsBuilder.from(url).queryParamIfPresent("paginacao.itensPorPagina", Optional.ofNullable(params.getOffset())).queryParamIfPresent("paginacao.paginaAtual", Optional.ofNullable(params.getPage())).queryParamIfPresent("inicio", Optional.ofNullable(UtilDate.dateToStr(params.getInitialDate(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("fim", Optional.ofNullable(UtilDate.dateToStr(params.getFinalDate(), UtilDate.Mask.TRACE_FORMATTER))).build();
    }
}

