/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.pix.impl.santander;

import com.touchcomp.basementorbanks.constants.DocumentType;
import com.touchcomp.basementorbanks.constants.StatusPixType;
import com.touchcomp.basementorbanks.constants.StatusType;
import com.touchcomp.basementorbanks.constants.ValueType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.Pageable;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.billing.pix.PixBillingConverter;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.PixListAll;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDue;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDueParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNow;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNowParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixreturn.PixReturn;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixreturn.PixReturnParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPix;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixListAll;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixParam;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.impl.santander.SantanderWorkspaceImpl;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.Workspace;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListAll;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceParams;
import com.touchcomp.basementorbanks.util.UtilDate;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.io.IOException;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;

public class SantanderPixConverter
extends BankJsonConverter
implements PixBillingConverter {
    private final int MODALIDADE_VALOR_PERCENTUAL = 2;
    private final int MODALIDADE_VALOR_FIXO = 1;

    public WorkspaceListAll textToWorkspaces(String json) throws BankException {
        return null;
    }

    @Override
    public Workspace toObjectWorkspace(String json) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Workspace aux = new Workspace();
            JsonNode account = mapper.readTree(json);
            String id = account.findValue("id").getTextValue();
            String type = account.findValue("type").getTextValue();
            String status = account.findValue("status").getTextValue();
            String webhookURL = account.findValue("webhookURL").getTextValue();
            Boolean bankSlipBillingWebhookActive = account.findValue("bankSlipBillingWebhookActive").getBooleanValue();
            Boolean pixBillingWebhookActive = account.findValue("pixBillingWebhookActive").getBooleanValue();
            List covenants = account.findValuesAsText("coventants");
            aux.setBankSlipBillingWebhookActive(bankSlipBillingWebhookActive);
            aux.setCovenants(covenants);
            aux.setWorkspaceId(id);
            aux.setPixBillingWebhookActive(pixBillingWebhookActive);
            if (Objects.equals(status, StatusType.ACTIVE.getType())) {
                aux.setStatusType(StatusType.ACTIVE);
            } else {
                aux.setStatusType(StatusType.ACTIVE);
            }
            aux.setWorkspaceType(type);
            aux.setWebhookURL(webhookURL);
            return aux;
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    @Override
    public String toText(WorkspaceParams workspace) throws BankException {
        JSONObject root = new JSONObject();
        root.put("webhookURL", (Object)workspace.getWebhookURL());
        root.put("bankSlipBillingWebhookActive", (Object)workspace.getBankSlipBillingWebhookActive());
        root.put("pixBillingWebhookActive", (Object)workspace.getPixBillingWebhookActive());
        LinkedList<String> covenants = new LinkedList<String>();
        for (String coventant : workspace.getCovenants()) {
            covenants.add(coventant);
        }
        root.put("covenants", covenants);
        return root.toString();
    }

    @Override
    public String toText(WebhookPixParam params) throws BankException {
        JSONObject root = new JSONObject();
        root.put("webhookURL", (Object)params.getWebHookUrl());
        return root.toString();
    }

    @Override
    public WebhookPix toObjectWebhook(String json) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(json);
            return this.convertNodeToWebhook(root);
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    @Override
    public WebhookPixListAll toObjectWorkspaceListAll(String json) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            WebhookPixListAll aux = new WebhookPixListAll();
            JsonNode account = mapper.readTree(json);
            JsonNode paramsNode = account.findValue("parametros");
            String startDate = paramsNode.findValue("inicio").getTextValue();
            String endDate = paramsNode.findValue("fim").getTextValue();
            aux.setInitialDate(startDate);
            aux.setFinalDate(endDate);
            JsonNode pageNode = paramsNode.findValue("paginacao");
            Integer page = pageNode.findValue("paginaAtual").getIntValue();
            Integer elements = pageNode.findValue("itensPorPagina").getIntValue();
            Integer totalPages = pageNode.findValue("quantidadeDePaginas").getIntValue();
            Integer totalElements = pageNode.findValue("quantidadeTotalDeItens").getIntValue();
            Pageable pageable = new Pageable();
            pageable.setTotalElements(totalElements);
            pageable.setOffset(elements);
            pageable.setPageNumber(page);
            pageable.setTotalPages(totalPages);
            List content = account.findValues("webhooks");
            LinkedList<WebhookPix> data = new LinkedList<WebhookPix>();
            for (JsonNode jsonNode : content) {
                data.add(this.convertNodeToWebhook(jsonNode));
            }
            aux.setWebhooks(data);
            return aux;
        }
        catch (IOException ex) {
            Logger.getLogger(SantanderWorkspaceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new BankException(ex);
        }
    }

    private WebhookPix convertNodeToWebhook(JsonNode root) {
        WebhookPix aux = new WebhookPix();
        String key = this.asText(root, "chave");
        String webhookUrl = this.asText(root, "webhookUrl");
        LocalDate creationDate = this.asLocalDate(root, "criacao", UtilDate.Mask.TRACE_FORMATTER);
        aux.setCreationDate(creationDate);
        aux.setDictKey(key);
        aux.setWebhookUrl(webhookUrl);
        return aux;
    }

    @Override
    public String toText(PixNowParams params) throws BankException {
        JSONObject root = new JSONObject();
        root.put("chave", (Object)params.getKey());
        root.put("solicitacaoPagador", (Object)params.getDescription());
        JSONObject calendarNode = new JSONObject();
        calendarNode.put("expiracao", (Object)params.getCalendar().getExpirationSeconds());
        root.put("calendario", (Object)calendarNode);
        JSONObject payerNode = new JSONObject();
        payerNode.put("cpf", (Object)params.getPayer().getDocument());
        payerNode.put("nome", (Object)params.getPayer().getName());
        root.put("devedor", (Object)payerNode);
        JSONObject valueNode = new JSONObject();
        valueNode.put("original", (Object)params.getValue());
        root.put("valor", (Object)valueNode);
        if (params.getInformation() != null) {
            LinkedList<JSONObject> nodes = new LinkedList<JSONObject>();
            for (PixNowParams.AdditionalInformation inf : params.getInformation()) {
                JSONObject aux = new JSONObject();
                aux.put("nome", (Object)inf.getKey());
                aux.put("valor", (Object)inf.getValue());
                nodes.add(aux);
            }
            root.put("infoAdicionais", nodes);
        }
        return root.toString();
    }

    @Override
    public PixNow toObjectPixNow(String json) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            PixNow aux = new PixNow();
            JsonNode root = mapper.readTree(json);
            JsonNode calendarNode = root.findValue("calendario");
            Integer expiration = this.asInt(calendarNode, "expiracao");
            String createDate = this.asText(calendarNode, "criacao");
            PixNow.Calendar calendar = new PixNow.Calendar();
            calendar.setExpirationSeconds(expiration);
            calendar.setCreationDate(createDate);
            aux.setCalendar(calendar);
            JsonNode payerNode = root.findValue("devedor");
            String name = payerNode.findValue("name").getTextValue();
            String cnpj = payerNode.findValue("cnpj").getTextValue();
            String cpf = payerNode.findValue("cpf").getTextValue();
            PixNow.Payer payer = new PixNow.Payer();
            payer.setName(name);
            if (UtilMethods.isStrWithData(cpf)) {
                payer.setDocument(cpf);
                payer.setDocumentType(DocumentType.CPF);
            } else {
                payer.setDocument(cnpj);
                payer.setDocumentType(DocumentType.CNPJ);
            }
            aux.setPayer(payer);
            String status = this.asText(root, "status");
            String location = this.asText(root, "Integer");
            String txtid = this.asText(root, "txtid");
            Integer revision = this.asInt(root, "revisao");
            String key = this.asText(root, "chave");
            String description = this.asText(root, "solicitacaoPagador");
            aux.setStatusType(this.getStatus(status));
            aux.setLocation(location);
            aux.setTransationPixId(txtid);
            aux.setKey(key);
            aux.setDescription(description);
            aux.setRevision(revision);
            List content = root.findValues("infoAdicionais");
            LinkedList<PixNow.AdditionalInformation> data = new LinkedList<PixNow.AdditionalInformation>();
            for (JsonNode jsonNode : content) {
                String keyPair = this.asText(jsonNode, "nome");
                String value = this.asText(jsonNode, "valor");
                PixNow.AdditionalInformation ad = new PixNow.AdditionalInformation();
                ad.setKey(keyPair);
                ad.setValue(value);
                data.add(ad);
            }
            aux.setInformation(data);
            return aux;
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    public StatusPixType getStatus(String status) {
        return switch (status) {
            case "ACTIVE" -> StatusPixType.ACTIVE;
            case "CONCLUDED" -> StatusPixType.CONCLUDED;
            case "REMOVED_BY_RECEIVING_USER" -> StatusPixType.REMOVED_BY_RECEIVING_USER;
            case "REMOVED_BY_PSP" -> StatusPixType.REMOVED_BY_PSP;
            default -> StatusPixType.UNDEFINED;
        };
    }

    @Override
    public String toText(PixDueParams params) throws BankException {
        JSONObject root = new JSONObject();
        JSONObject calendarNode = new JSONObject();
        calendarNode.put("dataVencimento", (Object)params.getCalendar().getPixDueDate());
        calendarNode.put("validadeAposVencimento", (Object)params.getCalendar().getPixDueDaysAfter());
        root.put("calendario", (Object)calendarNode);
        JSONObject payerNode = new JSONObject();
        if (params.getPayer() != null) {
            payerNode.put("logradouro", (Object)params.getPayer().getAddress());
            payerNode.put("cidade", (Object)params.getPayer().getCity());
            payerNode.put("uf", (Object)params.getPayer().getStateAbbreviationType().getValue());
            payerNode.put("cep", (Object)params.getPayer().getPostalCode());
            payerNode.put("nome", (Object)params.getPayer().getName());
            if (Objects.equals((Object)params.getPayer().getDocumentType(), (Object)DocumentType.CPF)) {
                payerNode.put("cpf", (Object)params.getPayer().getDocument());
            } else {
                payerNode.put("cnpj", (Object)params.getPayer().getDocument());
            }
            root.put("devedor", (Object)payerNode);
        }
        JSONObject valueNode = new JSONObject();
        valueNode.put("original", (Object)params.getValues().getValue());
        if (params.getValues().getFineValue() != null && params.getValues().getFineValue() > 0.0) {
            JSONObject fineNode = new JSONObject();
            fineNode.put("valorPerc", (Object)params.getValues().getFineValue());
            if (Objects.equals((Object)params.getValues().getFineValueType(), (Object)ValueType.VALUE)) {
                fineNode.put("modalidade", 1);
            } else {
                fineNode.put("modalidade", 2);
            }
            valueNode.put("multa", (Object)fineNode);
        }
        if (params.getValues().getInterestValue() != null && params.getValues().getInterestValue() > 0.0) {
            JSONObject interestNode = new JSONObject();
            interestNode.put("valorPerc", (Object)params.getValues().getInterestValue());
            if (Objects.equals((Object)params.getValues().getInterestValueType(), (Object)ValueType.VALUE)) {
                interestNode.put("modalidade", 1);
            } else {
                interestNode.put("modalidade", 2);
            }
            valueNode.put("multa", (Object)interestNode);
        }
        if (params.getValues().getRebateValue() != null && params.getValues().getRebateValue() > 0.0) {
            JSONObject rebateNode = new JSONObject();
            rebateNode.put("valorPerc", (Object)params.getValues().getRebateValue());
            if (Objects.equals((Object)params.getValues().getRebateValueType(), (Object)ValueType.VALUE)) {
                rebateNode.put("modalidade", 1);
            } else {
                rebateNode.put("modalidade", 2);
            }
            valueNode.put("abatimento", (Object)rebateNode);
        }
        if (params.getValues().getDiscountValue() != null && params.getValues().getDiscountValue() > 0.0) {
            JSONObject discountNode = new JSONObject();
            discountNode.put("valorPerc", (Object)params.getValues().getDiscountValue());
            if (Objects.equals((Object)params.getValues().getDiscountValueType(), (Object)ValueType.VALUE)) {
                discountNode.put("modalidade", 1);
            } else {
                discountNode.put("modalidade", 2);
            }
            valueNode.put("desconto", (Object)discountNode);
        }
        root.put("valor", (Object)valueNode);
        root.put("chave", (Object)params.getKey());
        root.put("solicitacaoPagador", (Object)params.getDescription());
        if (params.getInformation() != null) {
            LinkedList<JSONObject> nodes = new LinkedList<JSONObject>();
            for (PixDueParams.AdditionalInformation inf : params.getInformation()) {
                JSONObject aux = new JSONObject();
                aux.put("nome", (Object)inf.getKey());
                aux.put("valor", (Object)inf.getValue());
                nodes.add(aux);
            }
            root.put("infoAdicionais", nodes);
        }
        return root.toString();
    }

    @Override
    public PixDue toObjectPixDue(String json) throws BankException {
        try {
            JsonNode discountType;
            JsonNode rebateNode;
            JsonNode interestNode;
            ObjectMapper mapper = new ObjectMapper();
            PixDue aux = new PixDue();
            JsonNode root = mapper.readTree(json);
            JsonNode calendarNode = root.findValue("calendario");
            LocalDate creationDate = this.asLocalDate(calendarNode, "criacao", UtilDate.Mask.TRACE_FORMATTER);
            LocalDate dueDate = this.asLocalDate(calendarNode, "dataVencimento", UtilDate.Mask.TRACE_FORMATTER);
            Integer daysAfter = this.asInt(calendarNode, "validadeAposVencimento");
            PixDue.Calendar calendar = new PixDue.Calendar();
            calendar.setPixDueDate(dueDate);
            calendar.setPixIssueDate(creationDate);
            calendar.setPixDueDaysAfter(daysAfter);
            aux.setCalendar(calendar);
            JsonNode payerNode = root.findValue("devedor");
            String name = this.asText(payerNode, "name");
            String cnpj = this.asText(payerNode, "cnpj");
            String cpf = this.asText(payerNode, "cpf");
            String adddress = this.asText(payerNode, "logradouro");
            String city = this.asText(payerNode, "cidade");
            String state = this.asText(payerNode, "uf");
            String email = this.asText(payerNode, "email");
            String postalCode = this.asText(payerNode, "cep");
            PixDue.Payer payer = new PixDue.Payer();
            payer.setName(name);
            payer.setAddress(adddress);
            payer.setCity(city);
            payer.setPostalCode(postalCode);
            payer.setState(state);
            payer.setEmail(email);
            if (UtilMethods.isStrWithData(cpf)) {
                payer.setDocument(cpf);
                payer.setDocumentType(DocumentType.CPF);
            } else {
                payer.setDocument(cnpj);
                payer.setDocumentType(DocumentType.CNPJ);
            }
            aux.setPayer(payer);
            JsonNode valueNode = root.findValue("valor");
            PixDue.Values values = new PixDue.Values();
            Double valueTransaction = this.asDouble(valueNode, "original");
            values.setValue(valueTransaction);
            aux.setValue(values);
            JsonNode fineNode = valueNode.findValue("multa");
            if (fineNode != null) {
                Double valueOrPerc = this.asDouble(fineNode, "valorPerc");
                Integer type = this.asInt(fineNode, "modalidade");
                values.setFineValue(valueOrPerc);
                if (Objects.equals(type, 1)) {
                    values.setFineValueType(ValueType.VALUE);
                } else {
                    values.setFineValueType(ValueType.PERCENTAGE);
                }
            }
            if ((interestNode = valueNode.findValue("juros")) != null) {
                Double valueOrPerc = this.asDouble(interestNode, "valorPerc");
                Integer type = this.asInt(interestNode, "modalidade");
                values.setInterestValue(valueOrPerc);
                if (Objects.equals(type, 1)) {
                    values.setInterestValueType(ValueType.VALUE);
                } else {
                    values.setInterestValueType(ValueType.PERCENTAGE);
                }
            }
            if ((rebateNode = valueNode.findValue("abatimento")) != null) {
                Double valueOrPerc = this.asDouble(rebateNode, "valorPerc");
                Integer type = this.asInt(rebateNode, "modalidade");
                values.setRebateValue(valueOrPerc);
                if (Objects.equals(type, 1)) {
                    values.setRebateValueType(ValueType.VALUE);
                } else {
                    values.setRebateValueType(ValueType.PERCENTAGE);
                }
            }
            if ((discountType = valueNode.findValue("desconto")) != null) {
                Double valueOrPerc = this.asDouble(discountType, "valorPerc");
                Integer type = this.asInt(discountType, "modalidade");
                values.setDiscountValue(valueOrPerc);
                if (Objects.equals(type, 1)) {
                    values.setDiscountValueType(ValueType.VALUE);
                } else {
                    values.setDiscountValueType(ValueType.PERCENTAGE);
                }
            }
            String txtid = this.asText(payerNode, "txtid");
            Integer revision = this.asInt(payerNode, "revisao");
            String status = this.asText(payerNode, "status");
            String key = this.asText(payerNode, "chave");
            String description = this.asText(payerNode, "description");
            aux.setPixId(txtid);
            aux.setRevision(revision);
            aux.setStatus(this.getStatus(status));
            aux.setKey(key);
            aux.setDescription(description);
            List<JsonNode> content = this.asList(root, "infoAdicionais");
            LinkedList<PixDue.AdditionalInformation> data = new LinkedList<PixDue.AdditionalInformation>();
            for (JsonNode jsonNode : content) {
                String keyPair = this.asText(jsonNode, "nome");
                String value = this.asText(jsonNode, "valor");
                PixDue.AdditionalInformation ad = new PixDue.AdditionalInformation();
                ad.setKey(keyPair);
                ad.setValue(value);
                data.add(ad);
            }
            aux.setInformation(data);
            return aux;
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    @Override
    public String toText(PixReturnParams params) throws BankException {
        JSONObject root = new JSONObject();
        root.put("CNPJ", (Object)params.getDocument());
        root.put("valor", (Object)params.getReturnValue());
        return root.toString();
    }

    @Override
    public PixReturn toObjectAskReturn(String json) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            PixReturn aux = new PixReturn();
            JsonNode root = mapper.readTree(json);
            JsonNode hourNode = root.findValue("horario");
            LocalDate creationDate = this.asLocalDate(hourNode, "solicitacao", UtilDate.Mask.TRACE_FORMATTER);
            LocalDate endDate = this.asLocalDate(hourNode, "liquidacao", UtilDate.Mask.TRACE_FORMATTER);
            aux.setCreationDate(creationDate);
            aux.setEndDate(endDate);
            String id = this.asText(root, "id");
            String returnTransactionId = this.asText(root, "rtrId");
            Double returnValue = this.asDouble(root, "valor");
            String status = this.asText(root, "status");
            String description = this.asText(root, "motivo");
            aux.setDescription(description);
            aux.setReturnId(id);
            aux.setStatusType(status);
            aux.setValue(returnValue);
            aux.setReturnTransactionId(returnTransactionId);
            return aux;
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    @Override
    public PixListAll toObjectPixListAll(String json) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            PixListAll aux = new PixListAll();
            JsonNode root = mapper.readTree(json);
            JsonNode parametrosNode = root.findValue("parametros");
            List content = root.findValues("pix");
            LinkedList data = new LinkedList();
            for (JsonNode jsonNode : content) {
            }
            return aux;
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }
}

