/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.pix.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessBooleanResult;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.billing.pix.PixBillingConverter;
import com.touchcomp.basementorbanks.services.impl.billing.pix.PixBillingInterface;
import com.touchcomp.basementorbanks.services.impl.billing.pix.PixBillingURL;
import com.touchcomp.basementorbanks.services.impl.billing.pix.PixBillingValid;
import com.touchcomp.basementorbanks.services.impl.billing.pix.impl.santander.SantanderPixBillingURLImpl;
import com.touchcomp.basementorbanks.services.impl.billing.pix.impl.santander.SantanderPixConverter;
import com.touchcomp.basementorbanks.services.impl.billing.pix.impl.santander.SantanderValidBillingPixImpl;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.PixListAll;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.PixListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDue;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDueCancelParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDueListParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDueParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNow;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNowCancelParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNowListParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNowParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixreturn.PixReturn;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixreturn.PixReturnListParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixreturn.PixReturnParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPix;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixCancelParam;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixListAll;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixListAllParam;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixListParam;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixParam;
import com.touchcomp.basementorbanks.url.PixURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;

public class SantanderPixImpl
extends SantanderBaseConnection
implements PixBillingInterface {
    private final PixBillingConverter converter = new SantanderPixConverter();
    private final PixBillingURL urlConverter = new SantanderPixBillingURLImpl();
    private final PixBillingValid validator = new SantanderValidBillingPixImpl();

    private PixURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getPixURL();
        }
        return new SantanderHomoURL().getPixURL();
    }

    @Override
    public ProcessResult<PixNowParams, PixNow> createPixNow(PixNowParams params) throws BankException {
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getCreatePixNowUrl(params);
            String body = this.converter.toText(params);
            WebhookPix ret = null;
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.toObjectWebhook(res.getBody());
            }
            return new ProcessResult<PixNowParams, WebhookPix>(params, ret, res);
        }
        return new ProcessResult<PixNowParams, PixNow>(params, contraintValidation);
    }

    @Override
    public ProcessBooleanResult cancelPixNow(PixNowCancelParams params) throws BankException {
        String url = this.urlConverter.getCancelPixNowUrl(params);
        Boolean ret = false;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            ret = true;
        }
        return new ProcessBooleanResult<PixNowCancelParams>(params, ret, contraintValidation);
    }

    @Override
    public ProcessResult<PixNowListParams, PixNow> listPixNow(PixNowListParams params) throws BankException {
        String url = this.urlConverter.getListPixNowUrl(params);
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            WebhookPix ret = null;
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectWebhook(res.getBody());
            }
            return new ProcessResult<PixNowListParams, WebhookPix>(params, ret, res);
        }
        return new ProcessResult<PixNowListParams, PixNow>(params, contraintValidation);
    }

    @Override
    public ProcessResult<WebhookPixListParam, WebhookPix> createWebhook(WebhookPixParam params) throws BankException {
        String url = this.urlConverter.getCreateWebhookUrl(params);
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String body = this.converter.toText(params);
            WebhookPix ret = null;
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.toObjectWebhook(res.getBody());
            }
            return new ProcessResult<WebhookPixParam, WebhookPix>(params, ret, res);
        }
        return new ProcessResult(params, contraintValidation);
    }

    @Override
    public ProcessBooleanResult cancelWebhook(WebhookPixCancelParam params) throws BankException {
        String url = this.urlConverter.getCancelWebhookUrl(params);
        Boolean ret = false;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            ResponseResult res = this.exchangeDeleteData(params.getToken(), url);
            ret = true;
        }
        return new ProcessBooleanResult<WebhookPixCancelParam>(params, ret, contraintValidation);
    }

    @Override
    public ProcessResult<WebhookPixListParam, WebhookPix> listWebHooks(WebhookPixListParam params) throws BankException {
        String url = this.urlConverter.getListWebHookUrl(params);
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            WebhookPix ret = null;
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectWebhook(res.getBody());
            }
            return new ProcessResult<WebhookPixListParam, WebhookPix>(params, ret, res);
        }
        return new ProcessResult<WebhookPixListParam, WebhookPix>(params, contraintValidation);
    }

    @Override
    public ProcessResult<WebhookPixListAllParam, WebhookPixListAll> listAllWebHooks(WebhookPixListAllParam params) throws BankException {
        String url = this.urlConverter.getListAllWebhookUrl(params);
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            WebhookPixListAll ret = null;
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectWorkspaceListAll(res.getBody());
            }
            return new ProcessResult<WebhookPixListAllParam, WebhookPixListAll>(params, ret, res);
        }
        return new ProcessResult<WebhookPixListAllParam, WebhookPixListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<PixDueParams, PixDue> createPixDue(PixDueParams params) throws BankException {
        String url = this.urlConverter.getCreatePixDueUrl(params);
        String body = this.converter.toText(params);
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            PixDue ret = null;
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.toObjectPixDue(res.getBody());
            }
            return new ProcessResult<PixDueParams, PixDue>(params, ret, res);
        }
        return new ProcessResult<PixDueParams, PixDue>(params, contraintValidation);
    }

    @Override
    public ProcessBooleanResult cancelPixDue(PixDueCancelParams params) throws BankException {
        String url = this.urlConverter.getCancelPixDueUrl(params);
        Boolean ret = false;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            ret = true;
        }
        return new ProcessBooleanResult<PixDueCancelParams>(params, ret, contraintValidation);
    }

    @Override
    public ProcessResult<PixDueParams, PixDue> listPixDue(PixDueListParams params) throws BankException {
        String url = this.urlConverter.getListPixDueUrl(params);
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            PixDue ret = null;
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectPixDue(res.getBody());
            }
            return new ProcessResult<PixDueListParams, PixDue>(params, ret, res);
        }
        return new ProcessResult(params, contraintValidation);
    }

    @Override
    public ProcessResult<PixListAllParams, PixListAll> listAll(PixListAllParams params) throws BankException {
        String url = this.urlConverter.getListAllUrl(params);
        PixListAll ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectPixListAll(res.getBody());
            }
            return new ProcessResult<PixListAllParams, PixListAll>(params, ret, res);
        }
        return new ProcessResult<PixListAllParams, PixListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<PixReturnParams, PixReturn> pixReturn(PixReturnParams params) throws BankException {
        String url = this.urlConverter.getAskReturnUrl(params);
        PixReturn ret = null;
        String body = this.converter.toText(params);
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            ResponseResult res = this.exchangePutData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.toObjectAskReturn(res.getBody());
            }
            return new ProcessResult<PixReturnParams, PixReturn>(params, ret, res);
        }
        return new ProcessResult<PixReturnParams, PixReturn>(params, contraintValidation);
    }

    @Override
    public ProcessResult<PixReturnParams, PixReturn> listPixReturn(PixReturnListParams params) throws BankException {
        String url = this.urlConverter.getListPixReturnUrl(params);
        PixReturn ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectAskReturn(res.getBody());
            }
            return new ProcessResult<PixReturnListParams, PixReturn>(params, ret, res);
        }
        return new ProcessResult(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        PixURLInterface workspaceUrl = this.getUrl(credentials.getEnvironmentType());
        return this.getToken(credentials, workspaceUrl.getAuthUrl());
    }
}

