/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.pix.impl.santander;

import am.ik.yavi.builder.ValidatorBuilder;
import am.ik.yavi.constraint.CharSequenceConstraint;
import am.ik.yavi.constraint.CollectionConstraint;
import am.ik.yavi.constraint.DoubleConstraint;
import am.ik.yavi.constraint.EnumConstraint;
import am.ik.yavi.constraint.IntegerConstraint;
import am.ik.yavi.constraint.LocalDateConstraint;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.Validator;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.services.impl.billing.pix.PixBillingValid;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.PixListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDueCancelParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDueListParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixdue.PixDueParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNowCancelParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNowListParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixnow.PixNowParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixreturn.PixReturnListParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.pixreturn.PixReturnParams;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixCancelParam;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixListAllParam;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixListParam;
import com.touchcomp.basementorbanks.services.impl.billing.pix.model.webhook.WebhookPixParam;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceParams;

public class SantanderValidBillingPixImpl
implements PixBillingValid {
    private Validator<BankToken> getTokenValidation() {
        Validator bankCredentials = ValidatorBuilder.of(BankCredentials.class).constraint(BankCredentials::getEnvironmentType, "environmentType", c -> (EnumConstraint)c.notNull()).build();
        return ValidatorBuilder.of(BankToken.class).constraint(BankToken::getToken, "token", c -> c.notBlank()).nest(BankToken::getBankCredentials, "bankCredentials", bankCredentials).build();
    }

    public ConstraintViolations isValid(WorkspaceParams params) {
        Validator validator = ValidatorBuilder.of(WorkspaceParams.class).constraint(WorkspaceParams::getWorkspaceId, "workspaceId", c -> c.notBlank()).constraint(WorkspaceParams::getCovenants, "covenants", c -> (CollectionConstraint)c.notEmpty()).constraint(WorkspaceParams::getWorkspaceType, "workspaceType", c -> c.notBlank()).nest(WorkspaceParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixNowParams params) {
        Validator calendarValidator = ValidatorBuilder.of(PixNowParams.Calendar.class).constraint(PixNowParams.Calendar::getExpirationSeconds, "dueDate", c -> (IntegerConstraint)c.greaterThan((Object)0)).build();
        Validator payerValidator = ValidatorBuilder.of(PixNowParams.Payer.class).constraint(PixNowParams.Payer::getDocument, "document", c -> (CharSequenceConstraint)c.notNull()).constraint(PixNowParams.Payer::getDocumentType, "documentType", c -> (EnumConstraint)c.notNull()).build();
        Validator validator = ValidatorBuilder.of(PixNowParams.class).constraint(PixNowParams::getPixId, "transactionPixId", c -> (CharSequenceConstraint)c.notNull()).constraint(PixNowParams::getKey, "key", c -> (CharSequenceConstraint)c.notNull()).constraint(PixNowParams::getValue, "value", c -> (DoubleConstraint)c.notNull()).nest(PixNowParams::getToken, "bankToken", this.getTokenValidation()).nest(PixNowParams::getCalendar, "calendar", calendarValidator).nest(PixNowParams::getPayer, "payer", payerValidator).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixNowCancelParams params) {
        Validator validator = ValidatorBuilder.of(PixNowCancelParams.class).constraint(PixNowCancelParams::getPixId, "transactionPixId", c -> (CharSequenceConstraint)c.notNull()).nest(PixNowCancelParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixNowListParams params) {
        Validator validator = ValidatorBuilder.of(PixNowListParams.class).nest(PixNowListParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(WebhookPixListParam params) {
        Validator validator = ValidatorBuilder.of(WebhookPixListParam.class).constraint(WebhookPixListParam::getDictKey, "dictKey", c -> (CharSequenceConstraint)c.notNull()).nest(WebhookPixListParam::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(WebhookPixParam params) {
        Validator validator = ValidatorBuilder.of(WebhookPixParam.class).constraint(WebhookPixParam::getWebHookUrl, "webhookUrl", c -> (CharSequenceConstraint)c.notNull()).nest(WebhookPixParam::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(WebhookPixListAllParam params) {
        Validator validator = ValidatorBuilder.of(WebhookPixListAllParam.class).nest(WebhookPixListAllParam::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixDueParams params) {
        Validator calendarValidator = ValidatorBuilder.of(PixDueParams.Calendar.class).constraint(PixDueParams.Calendar::getPixDueDate, "dueDate", c -> (LocalDateConstraint)c.notNull()).build();
        Validator payerValidator = ValidatorBuilder.of(PixDueParams.Payer.class).constraint(PixDueParams.Payer::getDocument, "document", c -> (CharSequenceConstraint)c.notNull()).constraint(PixDueParams.Payer::getDocumentType, "documentType", c -> (EnumConstraint)c.notNull()).build();
        Validator valueValidator = ValidatorBuilder.of(PixDueParams.Values.class).constraint(PixDueParams.Values::getValue, "document", c -> (DoubleConstraint)c.greaterThan((Object)0.0)).build();
        Validator validator = ValidatorBuilder.of(PixDueParams.class).constraint(PixDueParams::getPixId, "transactionPixId", c -> (CharSequenceConstraint)c.notNull()).constraint(PixDueParams::getKey, "key", c -> (CharSequenceConstraint)c.notNull()).nest(PixDueParams::getToken, "bankToken", this.getTokenValidation()).nest(PixDueParams::getCalendar, "calendar", calendarValidator).nest(PixDueParams::getPayer, "payer", payerValidator).nest(PixDueParams::getValues, "values", valueValidator).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixDueCancelParams params) {
        Validator validator = ValidatorBuilder.of(PixDueCancelParams.class).constraint(PixDueCancelParams::getPixId, "transactionPixId", c -> (CharSequenceConstraint)c.notNull()).nest(PixDueCancelParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixDueListParams params) {
        Validator validator = ValidatorBuilder.of(PixDueListParams.class).constraint(PixDueListParams::getPixId, "transactionPixId", c -> (CharSequenceConstraint)c.notNull()).nest(PixDueListParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixListAllParams params) {
        Validator validator = ValidatorBuilder.of(PixListAllParams.class).nest(PixListAllParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixReturnParams params) {
        Validator validator = ValidatorBuilder.of(PixReturnParams.class).constraint(PixReturnParams::getEndToEndTransaction, "endToendTransacion", c -> c.notBlank()).constraint(PixReturnParams::getReturnTransactionId, "returnTransactionId", c -> (CharSequenceConstraint)c.notEmpty()).constraint(PixReturnParams::getReturnValue, "returnValue", c -> (DoubleConstraint)c.notNull()).nest(PixReturnParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixReturnListParams params) {
        Validator validator = ValidatorBuilder.of(PixReturnListParams.class).constraint(PixReturnListParams::getEndToEndTransaction, "endToendTransacion", c -> c.notBlank()).constraint(PixReturnListParams::getReturnTransactionId, "returnTransactionId", c -> (CharSequenceConstraint)c.notEmpty()).nest(PixReturnListParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(WebhookPixCancelParam params) {
        Validator validator = ValidatorBuilder.of(WebhookPixCancelParam.class).constraint(WebhookPixCancelParam::getDictKey, "dictKey", c -> (CharSequenceConstraint)c.notNull()).nest(WebhookPixCancelParam::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }
}

