/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.slipbilling;

import com.touchcomp.basementorbanks.constants.BankType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankNotSupportedException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.SlipBillingInterface;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.impl.santander.SantanderSlipBillImpl;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.BankSlip;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.BankSlipListAll;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipListParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipParams;

public class BankSlipBilling {
    public ProcessResult<SlipParams, BankSlip> create(SlipParams params) throws BankException, BankNotSupportedException {
        SlipBillingInterface found = this.get(params.getToken().getBankCredentials());
        return found.create(params);
    }

    public ProcessResult<SlipParams, BankSlip> update(SlipParams params) throws BankException, BankNotSupportedException {
        SlipBillingInterface found = this.get(params.getToken().getBankCredentials());
        return found.update(params);
    }

    public ProcessResult<SlipListAllParams, BankSlipListAll> listAll(SlipListAllParams params) throws BankException, BankNotSupportedException {
        SlipBillingInterface found = this.get(params.getToken().getBankCredentials());
        return found.listAll(params);
    }

    public ProcessResult<SlipListParams, BankSlip> list(SlipListParams params) throws BankException, BankNotSupportedException {
        SlipBillingInterface found = this.get(params.getToken().getBankCredentials());
        return found.list(params);
    }

    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials crendentials) throws BankException, BankNotSupportedException {
        SlipBillingInterface found = this.get(crendentials);
        return found.getToken(crendentials);
    }

    private SlipBillingInterface get(BankCredentials credentials) throws BankNotSupportedException {
        BankType type = credentials.getBankType();
        switch (type) {
            case SANTANDER: {
                return new SantanderSlipBillImpl();
            }
        }
        throw new BankNotSupportedException(type.toString());
    }
}

