/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.slipbilling.impl.santander;

import com.touchcomp.basementorbanks.constants.DocumentType;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.Pageable;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.SlipBillingConverter;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.BankSlip;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.BankSlipFile;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.BankSlipListAll;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipFileParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipListParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipParams;
import com.touchcomp.basementorbanks.util.UtilDate;
import com.touchcomp.basementorbanks.util.UtilDownload;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.JsonNode;
import org.json.JSONObject;

public class SantanderSlipBillConv
extends BankJsonConverter
implements SlipBillingConverter {
    private BankSlip convertNode(JsonNode root) {
        JsonNode keyNode;
        JsonNode beneficaryNode;
        BankSlip slip = new BankSlip();
        slip.setWorkspaceId(this.asText(root, "workspaceId"));
        slip.setNsuCode(this.asText(root, "nsuCode"));
        slip.setNsuDate(this.asLocalDate(root, "nsuDate", UtilDate.Mask.TRACE_FORMATTER));
        slip.setCovenantCode(this.asText(root, "covenantCode"));
        slip.setBankNumber(this.asText(root, "bankNumber"));
        slip.setClientNumber(this.asText(root, "clientNumber"));
        slip.setDueDate(this.asLocalDate(root, "dueDate", UtilDate.Mask.TRACE_FORMATTER));
        slip.setIssueDate(this.asLocalDate(root, "issueDate", UtilDate.Mask.TRACE_FORMATTER));
        slip.setParticipantCode(this.asText(root, "participantCode"));
        slip.setNominalValue(this.asDouble(root, "nominalValue"));
        JsonNode payerNode = root.findValue("payer");
        if (payerNode != null) {
            BankSlip.Payer payer = new BankSlip.Payer();
            payer.setName(this.asText(payerNode, "name"));
            String documentType = this.asText(payerNode, "documentType");
            if (Objects.equals(documentType, "CPF")) {
                payer.setDocumentType(DocumentType.CPF);
            } else {
                payer.setDocumentType(DocumentType.CNPJ);
            }
            payer.setDocumentNumber(this.asText(payerNode, "documentNumber"));
            payer.setAddress(this.asText(payerNode, "address"));
            payer.setNeighborhood(this.asText(payerNode, "neighborhood"));
            payer.setCity(this.asText(payerNode, "city"));
            payer.setState(this.asText(payerNode, "state"));
            payer.setZipCode(this.asText(payerNode, "zipCode"));
            slip.setPayer(payer);
        }
        if ((beneficaryNode = root.findValue("beneficiary")) != null) {
            BankSlip.Beneficiary beneficiary = new BankSlip.Beneficiary();
            beneficiary.setName(this.asText(payerNode, "name"));
            String documentType = this.asText(payerNode, "documentType");
            if (Objects.equals(documentType, "CPF")) {
                beneficiary.setDocumentType(DocumentType.CPF);
            } else {
                beneficiary.setDocumentType(DocumentType.CNPJ);
            }
            beneficiary.setDocumentNumber(this.asText(payerNode, "documentNumber"));
            slip.setBeneficiary(beneficiary);
        }
        slip.setDocumentKindType(this.asText(root, "documentKind"));
        JsonNode discountNode = root.findValue("discount");
        if (discountNode != null) {
            JsonNode discountNode3;
            Object discountNode2;
            BankSlip.Discount discount = new BankSlip.Discount();
            discount.setType(this.asText(discountNode, "type"));
            JsonNode discountNode1 = discountNode.findValue("discountOne");
            if (discountNode1 != null) {
                BankSlip.Discount.DiscountValue discount1 = new BankSlip.Discount.DiscountValue();
                discount1.setLimitDate(this.asLocalDate(discountNode1, "limitDate", UtilDate.Mask.TRACE_FORMATTER));
                discount1.setValue(this.asDouble(discountNode1, "value"));
                discount.setDiscountOne(discount1);
            }
            if ((discountNode2 = discountNode.findValue("discountTwo")) != null) {
                BankSlip.Discount.DiscountValue discount2 = new BankSlip.Discount.DiscountValue();
                discount2.setLimitDate(this.asLocalDate((JsonNode)discountNode2, "limitDate", UtilDate.Mask.TRACE_FORMATTER));
                discount2.setValue(this.asDouble((JsonNode)discountNode2, "value"));
                discount.setDiscountTwo(discount2);
            }
            if ((discountNode3 = discountNode.findValue("discountThree")) != null) {
                BankSlip.Discount.DiscountValue discount3 = new BankSlip.Discount.DiscountValue();
                discount3.setLimitDate(this.asLocalDate(discountNode3, "limitDate", UtilDate.Mask.TRACE_FORMATTER));
                discount3.setValue(this.asDouble(discountNode3, "value"));
                discount.setDiscountThree(discount3);
            }
            slip.setDiscount(discount);
        }
        slip.setFinePercentage(this.asDouble(root, "finePercentage"));
        slip.setFineQuantityDays(this.asInt(root, "fineQuantityDays"));
        slip.setInterestPercentage(this.asDouble(root, "interestPercentage"));
        slip.setDeductionValue(this.asDouble(root, "deductionValue"));
        slip.setProtestType(this.asText(root, "protestType"));
        slip.setProtestQuantityDays(this.asInt(root, "protestQuantityDays"));
        slip.setWriteOffQuantityDays(this.asInt(root, "writeOffQuantityDays"));
        slip.setPaymentType(this.asText(root, "paymentType"));
        slip.setParcelsQuantity(this.asInt(root, "parcelsQuantity"));
        slip.setValueType(this.asText(root, "valueType"));
        slip.setMinValueOrPercentage(this.asDouble(root, "minValueOrPercentage"));
        slip.setMaxValueOrPercentage(this.asDouble(root, "maxValueOrPercentage"));
        slip.setIofPercentage(this.asDouble(root, "iofPercentage"));
        slip.setValueType(this.asText(root, "valueType"));
        List<JsonNode> sharingsNode = this.asList(root, "sharing");
        LinkedList<BankSlip.Sharing> sharings = new LinkedList<BankSlip.Sharing>();
        if (sharingsNode != null) {
            for (JsonNode sharingNd : sharingsNode) {
                BankSlip.Sharing sharing = new BankSlip.Sharing();
                sharing.setCode(this.asText(sharingNd, "code"));
                sharing.setValue(this.asDouble(sharingNd, "value"));
                sharings.add(sharing);
            }
            slip.setSharing(sharings);
        }
        if ((keyNode = root.findValue("key")) != null) {
            BankSlip.Key sharing = new BankSlip.Key();
            sharing.setType(this.asText(keyNode, "type"));
            sharing.setDictKey(this.asText(keyNode, "dictKey"));
            slip.setKey(sharing);
        }
        slip.setTxId(this.asText(root, "txId"));
        slip.setMessages(this.asStringList(root, "messages"));
        slip.setBarcode(this.asText(root, "barcode"));
        slip.setDigitableLine(this.asText(root, "digitableLine"));
        slip.setEntryDate(this.asLocalDate(root, "entryDate", UtilDate.Mask.TRACE_FORMATTER));
        slip.setQrCodePix(this.asText(root, "qrCodePix"));
        slip.setQrCodeUrl(this.asText(root, "qrCodeUrl"));
        return slip;
    }

    @Override
    public String toText(SlipParams params, EnvironmentType environmentType) {
        JSONObject root = new JSONObject();
        root.put("workspaceId", (Object)params.getWorkspaceId());
        root.put("environment", (Object)params.getToken().getBankCredentials().getEnvironmentType());
        root.put("nsuCode", (Object)params.getNsuCode());
        root.put("nsuDate", (Object)UtilDate.dateToStr(params.getNsuDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("covenantCode", (Object)params.getCovenantCode());
        root.put("bankNumber", (Object)params.getBankNumber());
        root.put("clientNumber", (Object)params.getClientNumber());
        root.put("dueDate", (Object)UtilDate.dateToStr(params.getDueDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("issueDate", (Object)UtilDate.dateToStr(params.getIssueDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("participantCode", (Object)params.getParticipantCode());
        root.put("nominalValue", (Object)params.getNominalValue());
        if (params.getPayer() != null) {
            JSONObject payer = new JSONObject();
            payer.put("name", (Object)params.getPayer().getName());
            payer.put("documentType", (Object)params.getPayer().getDocumentType().getValue());
            payer.put("documentNumber", (Object)params.getPayer().getDocumentNumber());
            payer.put("address", (Object)params.getPayer().getAddress());
            payer.put("neighborhood", (Object)params.getPayer().getNeighborhood());
            payer.put("city", (Object)params.getPayer().getCity());
            payer.put("state", (Object)params.getPayer().getState());
            payer.put("zipCode", (Object)params.getPayer().getZipCode());
            root.put("payer", (Object)payer);
        }
        if (params.getBeneficiary() != null) {
            JSONObject beneficiary = new JSONObject();
            beneficiary.put("name", (Object)params.getBeneficiary().getName());
            beneficiary.put("documentType", (Object)params.getBeneficiary().getDocumentType().getValue());
            beneficiary.put("documentNumber", (Object)params.getBeneficiary().getDocumentNumber());
            root.put("beneficiary", (Object)beneficiary);
        }
        root.put("documentKind", (Object)params.getDocumentKindType());
        if (params.getDiscount() != null) {
            JSONObject discount1;
            JSONObject discount = new JSONObject();
            discount.put("type", (Object)params.getDiscount().getType());
            if (params.getDiscount().getDiscountOne() != null) {
                discount1 = new JSONObject();
                discount1.put("value", (Object)params.getDiscount().getDiscountOne().getValue());
                discount1.put("limitDate", (Object)UtilDate.dateToStr(params.getDiscount().getDiscountOne().getLimitDate(), UtilDate.Mask.TRACE_FORMATTER));
                discount.put("discountOne", (Object)discount1);
            }
            if (params.getDiscount().getDiscountTwo() != null) {
                discount1 = new JSONObject();
                discount1.put("value", (Object)params.getDiscount().getDiscountTwo().getValue());
                discount1.put("limitDate", (Object)UtilDate.dateToStr(params.getDiscount().getDiscountTwo().getLimitDate(), UtilDate.Mask.TRACE_FORMATTER));
                discount.put("discountTwo", (Object)discount1);
            }
            if (params.getDiscount().getDiscountThree() != null) {
                discount1 = new JSONObject();
                discount1.put("value", (Object)params.getDiscount().getDiscountThree().getValue());
                discount1.put("limitThree", (Object)UtilDate.dateToStr(params.getDiscount().getDiscountThree().getLimitDate(), UtilDate.Mask.TRACE_FORMATTER));
                discount.put("discountOne", (Object)discount1);
            }
            root.put("discount", (Object)discount);
        }
        root.put("finePercentage", (Object)params.getFinePercentage());
        root.put("fineQuantityDays", (Object)params.getFineQuantityDays());
        root.put("interestPercentage", (Object)params.getInterestPercentage());
        root.put("deductionValue", (Object)params.getDeductionValue());
        root.put("protestType", (Object)params.getProtestType());
        root.put("protestQuantityDays", (Object)params.getProtestQuantityDays());
        root.put("writeOffQuantityDays", (Object)params.getWriteOffQuantityDays());
        root.put("paymentType", (Object)params.getPaymentType());
        root.put("parcelsQuantity", (Object)params.getParcelsQuantity());
        root.put("valueType", (Object)params.getValueType());
        root.put("minValueOrPercentage", (Object)params.getMinValueOrPercentage());
        root.put("maxValueOrPercentage", (Object)params.getMaxValueOrPercentage());
        root.put("iofPercentage", (Object)params.getIofPercentage());
        if (params.getSharing() != null) {
            LinkedList<JSONObject> nodes = new LinkedList<JSONObject>();
            for (SlipParams.Sharing sharing : params.getSharing()) {
                JSONObject sharingNode = new JSONObject();
                sharingNode.put("code", (Object)sharing.getCode());
                sharingNode.put("value", (Object)sharing.getValue());
                nodes.add(sharingNode);
            }
            root.put("sharing", nodes);
        }
        if (params.getKey() != null) {
            JSONObject key = new JSONObject();
            key.put("type", (Object)params.getKey().getType());
            key.put("dictKey", (Object)params.getKey().getDictKey());
            root.put("key", (Object)key);
        }
        root.put("txId", (Object)params.getTxId());
        root.put("messages", params.getMessages());
        return root.toString();
    }

    @Override
    public BankSlip toObject(String data, EnvironmentType environmentType) throws BankException {
        JsonNode root = this.getRoot(data);
        return this.convertNode(root);
    }

    @Override
    public String toText(SlipListAllParams params, EnvironmentType environmentType) throws BankException {
        return "";
    }

    @Override
    public BankSlipListAll toObjectListAll(String json, EnvironmentType environmentType) throws BankException {
        BankSlipListAll aux = new BankSlipListAll();
        JsonNode root = this.getRoot(json);
        Pageable page = new Pageable();
        page.setOffset(this.asInt(root, "_offset"));
        page.setPageNumber(this.asInt(root, "_pageNumber"));
        page.setPageElements(this.asInt(root, "_pageElements"));
        page.setTotalPages(this.asInt(root, "_totalPages"));
        page.setTotalElements(this.asInt(root, "_totalElements"));
        aux.setPageable(page);
        List<JsonNode> content = this.asList(root, "_content");
        LinkedList<BankSlip> temp = new LinkedList<BankSlip>();
        for (JsonNode jsonNode : content) {
            temp.add(this.convertNode(jsonNode));
        }
        aux.setSlips(temp);
        return aux;
    }

    @Override
    public String toText(SlipListParams params, EnvironmentType environmentType) throws BankException {
        return "";
    }

    @Override
    public String toText(SlipFileParams params, EnvironmentType environmentType) {
        JSONObject root = new JSONObject();
        root.put("payerDocumentNumber", (Object)params.getPayerDocumentNumber());
        return root.toString();
    }

    @Override
    public BankSlipFile toObjectSlipFile(String json, EnvironmentType environmentType) throws BankException {
        JsonNode root = this.getRoot(json);
        BankSlipFile aux = new BankSlipFile();
        aux.setLinkAdress(this.asText(root, "link"));
        aux.setPdfFile(UtilDownload.download(aux.getLinkAdress()));
        return aux;
    }
}

