/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.slipbilling.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.SlipBillingInterface;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.SlipBillingURL;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.SlipBillingValid;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.impl.santander.SantanderSlipBillConv;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.impl.santander.SantanderSlipBillURLConvImpl;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.impl.santander.SantanderSlipBillValImpl;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.BankSlip;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.BankSlipFile;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.BankSlipListAll;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipFileParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipListParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipParams;
import java.util.Objects;

public class SantanderSlipBillImpl
extends SantanderBaseConnection
implements SlipBillingInterface {
    private final SlipBillingValid validator = new SantanderSlipBillValImpl();
    private final SantanderSlipBillConv converter;
    private final SlipBillingURL urlConverter = new SantanderSlipBillURLConvImpl();

    public SantanderSlipBillImpl() {
        this.converter = new SantanderSlipBillConv();
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        return this.getToken(credentials, this.urlConverter.getAuth(credentials));
    }

    @Override
    public ProcessResult<SlipParams, BankSlip> create(SlipParams params) throws BankException {
        String url = this.urlConverter.getCreate(params);
        String body = this.converter.toText(params, params.getToken().getBankCredentials().getEnvironmentType());
        BankSlip ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.toObject(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<SlipParams, Object>(params, ret, res);
        }
        return new ProcessResult<SlipParams, BankSlip>(params, contraintValidation);
    }

    @Override
    public ProcessResult<SlipParams, BankSlip> update(SlipParams params) throws BankException {
        BankSlip ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getUpdate(params);
            String body = this.converter.toText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePatchData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.toObject(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<SlipParams, Object>(params, ret, res);
        }
        return new ProcessResult<SlipParams, BankSlip>(params, contraintValidation);
    }

    @Override
    public ProcessResult<SlipListParams, BankSlip> list(SlipListParams params) throws BankException {
        BankSlip ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getList(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObject(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<SlipListParams, Object>(params, ret, res);
        }
        return new ProcessResult<SlipListParams, BankSlip>(params, contraintValidation);
    }

    @Override
    public ProcessResult<SlipListAllParams, BankSlipListAll> listAll(SlipListAllParams params) throws BankException {
        BankSlipListAll ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListAll(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectListAll(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<SlipListAllParams, Object>(params, ret, res);
        }
        return new ProcessResult<SlipListAllParams, BankSlipListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<SlipFileParams, BankSlipFile> getPDFSlip(SlipFileParams params) throws BankException {
        if (Objects.equals((Object)params.getToken().getBankCredentials().getEnvironmentType(), (Object)EnvironmentType.HOMOLOGACAO)) {
            throw new BankException("E.BANK.000015", params.getSlipIdGen());
        }
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        BankSlipFile ret = null;
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getFile(params);
            String body = this.converter.toText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.toObjectSlipFile(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<SlipFileParams, Object>(params, ret, res);
        }
        return new ProcessResult<SlipFileParams, BankSlipFile>(params, contraintValidation);
    }
}

