/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.slipbilling.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.SlipBillingURL;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipFileParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipListParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipParams;
import com.touchcomp.basementorbanks.url.BillingSlipURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilDate;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Objects;
import java.util.Optional;

public class SantanderSlipBillURLConvImpl
implements SlipBillingURL {
    @Override
    public String getCreate(SlipParams params) {
        BillingSlipURLInterface workspaceUrl = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(workspaceUrl.getCreationBillingSlip(), params.getWorkspaceId());
    }

    @Override
    public String getUpdate(SlipParams params) {
        BillingSlipURLInterface workspaceUrl = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(workspaceUrl.getUpdateBillingSlip(), params.getWorkspaceId());
    }

    @Override
    public String getList(SlipListParams params) {
        BillingSlipURLInterface workspaceUrl = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        StringBuilder id = new StringBuilder();
        id.append(params.getNsuCode()).append(".");
        id.append(UtilDate.dateToStr(params.getNsuDate(), UtilDate.Mask.TRACE_FORMATTER)).append(".");
        if (Objects.equals((Object)params.getToken().getBankCredentials().getEnvironmentType(), (Object)EnvironmentType.HOMOLOGACAO)) {
            id.append("T").append(".");
        } else {
            id.append("P").append(".");
        }
        id.append(params.getCovenantCode()).append(".");
        id.append(params.getBankNumber());
        return UtilMethods.formatMessage(workspaceUrl.getBillingSlipList(), params.getWorkspaceId(), id.toString());
    }

    @Override
    public String getListAll(SlipListAllParams params) {
        BillingSlipURLInterface workspaceUrl = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(workspaceUrl.getBillingSlipListAll(), params.getWorkspaceId());
        return UriComponentsBuilder.from(url).queryParamIfPresent("_limit", Optional.ofNullable(params.getLimit())).queryParamIfPresent("_offset", Optional.ofNullable(params.getOffset())).queryParamIfPresent("bankNumber", Optional.ofNullable(params.getBankNumber())).queryParamIfPresent("clientNumber", Optional.ofNullable(params.getClientNumber())).queryParamIfPresent("dueDateInitial", Optional.ofNullable(UtilDate.dateToStr(params.getDueDateInitial(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("dueDateFinal", Optional.ofNullable(UtilDate.dateToStr(params.getDueDateFinal(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("paymentDateInitial", Optional.ofNullable(UtilDate.dateToStr(params.getPaymentDateInitial(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("paymentDateFinal", Optional.ofNullable(UtilDate.dateToStr(params.getPaymentDateFinal(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("status", Optional.ofNullable(params.getStatusType())).build();
    }

    @Override
    public String getAuth(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    private BillingSlipURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getBillingSlipURL();
        }
        return new SantanderHomoURL().getBillingSlipURL();
    }

    @Override
    public String getFile(SlipFileParams params) {
        BillingSlipURLInterface workspaceUrl = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String id = params.getSlipIdGen();
        return UtilMethods.formatMessage(workspaceUrl.getPDFSlip(), id);
    }
}

