/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.slipbilling.impl.santander;

import am.ik.yavi.builder.ValidatorBuilder;
import am.ik.yavi.constraint.DoubleConstraint;
import am.ik.yavi.constraint.EnumConstraint;
import am.ik.yavi.constraint.LocalDateConstraint;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.Validator;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.SlipBillingValid;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipFileParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipListParams;
import com.touchcomp.basementorbanks.services.impl.billing.slipbilling.model.SlipParams;

public class SantanderSlipBillValImpl
implements SlipBillingValid {
    @Override
    public ConstraintViolations isValid(SlipParams params) {
        Validator payer = ValidatorBuilder.of(SlipParams.Payer.class).constraint(SlipParams.Payer::getName, "name", c -> c.notBlank()).constraint(SlipParams.Payer::getDocumentType, "documentType", c -> (EnumConstraint)c.notNull()).constraint(SlipParams.Payer::getDocumentNumber, "documentNumber", c -> c.notBlank()).constraint(SlipParams.Payer::getAddress, "address", c -> c.notBlank()).constraint(SlipParams.Payer::getNeighborhood, "neighborhood", c -> c.notBlank()).constraint(SlipParams.Payer::getCity, "city", c -> c.notBlank()).constraint(SlipParams.Payer::getState, "state", c -> c.notBlank()).build();
        Validator validator = ValidatorBuilder.of(SlipParams.class).constraint(SlipParams::getWorkspaceId, "workspaceId", c -> c.notBlank()).constraint(SlipParams::getNsuCode, "nsuCode", c -> c.notBlank()).constraint(SlipParams::getNsuDate, "nsuDate", c -> (LocalDateConstraint)c.notNull()).constraint(SlipParams::getCovenantCode, "covenantCode", c -> c.notBlank()).constraint(SlipParams::getBankNumber, "bankNumber", c -> c.notBlank()).constraint(SlipParams::getDueDate, "bankNumber", c -> (LocalDateConstraint)c.notNull()).constraint(SlipParams::getIssueDate, "bankNumber", c -> (LocalDateConstraint)c.notNull()).constraint(SlipParams::getNominalValue, "nominalValue", c -> (DoubleConstraint)((DoubleConstraint)c.notNull()).greaterThan((Object)0.0)).constraint(SlipParams::getDocumentKindType, "documentKind", c -> c.notBlank()).constraint(SlipParams::getPaymentType, "paymentType", c -> c.notBlank()).nest(SlipParams::getToken, "bankToken", this.getTokenValidation()).nest(SlipParams::getPayer, "payer", payer).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(SlipListParams params) {
        Validator validator = ValidatorBuilder.of(SlipListParams.class).constraint(SlipListParams::getWorkspaceId, "workspaceId", c -> c.notBlank()).constraint(SlipListParams::getBankNumber, "bankNumber", c -> c.notBlank()).constraint(SlipListParams::getCovenantCode, "covenantCode", c -> c.notBlank()).constraint(SlipListParams::getNsuCode, "nsuCode", c -> c.notBlank()).constraint(SlipListParams::getNsuDate, "nsuDate", c -> (LocalDateConstraint)c.notNull()).nest(SlipListParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(SlipListAllParams params) {
        Validator validator = ValidatorBuilder.of(SlipListAllParams.class).constraint(SlipListAllParams::getWorkspaceId, "workspaceId", c -> c.notBlank()).constraint(SlipListAllParams::getStatusType, "statusType", c -> c.notBlank()).nest(SlipListAllParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    private Validator<BankToken> getTokenValidation() {
        Validator bankCredentials = ValidatorBuilder.of(BankCredentials.class).constraint(BankCredentials::getEnvironmentType, "environmentType", c -> (EnumConstraint)c.notNull()).build();
        return ValidatorBuilder.of(BankToken.class).constraint(BankToken::getToken, "token", c -> c.notBlank()).nest(BankToken::getBankCredentials, "bankCredentials", bankCredentials).build();
    }

    @Override
    public ConstraintViolations isValid(SlipFileParams params) {
        Validator validator = ValidatorBuilder.of(SlipFileParams.class).constraint(SlipFileParams::getSlipIdGen, "slipIdGen", c -> c.notBlank()).constraint(SlipFileParams::getPayerDocumentNumber, "payerDocumentNumber", c -> c.notBlank()).nest(SlipFileParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }
}

