/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.workspace;

import com.touchcomp.basementorbanks.constants.BankType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankNotSupportedException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessBooleanResult;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.WorkspaceInterface;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.impl.santander.SantanderWorkspaceImpl;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.Workspace;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceDeleteParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListAll;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceParams;

public class BankWorkspaceBilling {
    public ProcessResult<WorkspaceParams, Workspace> create(WorkspaceParams workspace) throws BankException, BankNotSupportedException {
        WorkspaceInterface found = this.get(workspace.getToken().getBankCredentials());
        return found.createWorkspace(workspace);
    }

    public ProcessResult<WorkspaceParams, Workspace> update(WorkspaceParams workspace) throws BankException, BankNotSupportedException {
        WorkspaceInterface found = this.get(workspace.getToken().getBankCredentials());
        return found.update(workspace);
    }

    public ProcessBooleanResult<WorkspaceDeleteParams> delete(WorkspaceDeleteParams workspace) throws BankException, BankNotSupportedException {
        WorkspaceInterface found = this.get(workspace.getToken().getBankCredentials());
        return found.delete(workspace);
    }

    public ProcessResult<WorkspaceListAllParams, WorkspaceListAll> listAll(WorkspaceListAllParams params) throws BankException, BankNotSupportedException {
        WorkspaceInterface found = this.get(params.getToken().getBankCredentials());
        return found.listAll(params);
    }

    public ProcessResult<WorkspaceListParams, Workspace> list(WorkspaceListParams workspace) throws BankException, BankNotSupportedException {
        WorkspaceInterface found = this.get(workspace.getToken().getBankCredentials());
        return found.list(workspace);
    }

    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials crendentials) throws BankException, BankNotSupportedException {
        WorkspaceInterface found = this.get(crendentials);
        return found.getToken(crendentials);
    }

    private WorkspaceInterface get(BankCredentials credentials) throws BankNotSupportedException {
        BankType type = credentials.getBankType();
        switch (type) {
            case SANTANDER: {
                return new SantanderWorkspaceImpl();
            }
        }
        throw new BankNotSupportedException(type.toString());
    }
}

