/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.workspace.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.constants.StatusType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.WorkspaceConverter;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.Workspace;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceDeleteParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListAll;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceParams;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.JsonNode;
import org.json.JSONObject;

public class SantanderWorkspaceConverterImpl
extends BankJsonConverter
implements WorkspaceConverter {
    private Workspace textToWorkspace(JsonNode root, EnvironmentType environmentType) {
        Workspace aux = new Workspace();
        String id = this.asText(root, "id");
        String type = this.asText(root, "type");
        String status = this.asText(root, "status");
        String webhookURL = this.asText(root, "webhookURL");
        Boolean bankSlipBillingWebhookActive = this.asBoolean(root, "bankSlipBillingWebhookActive");
        Boolean pixBillingWebhookActive = this.asBoolean(root, "pixBillingWebhookActive");
        List<String> covenants = this.asStringList(root, "coventants");
        aux.setBankSlipBillingWebhookActive(bankSlipBillingWebhookActive);
        aux.setCovenants(covenants);
        aux.setWorkspaceId(id);
        aux.setPixBillingWebhookActive(pixBillingWebhookActive);
        if (Objects.equals(status, StatusType.ACTIVE.getType())) {
            aux.setStatusType(StatusType.ACTIVE);
        } else {
            aux.setStatusType(StatusType.ACTIVE);
        }
        aux.setWorkspaceType(type);
        aux.setWebhookURL(webhookURL);
        return aux;
    }

    @Override
    public String toText(WorkspaceParams workspace, EnvironmentType environmentType) throws BankException {
        JSONObject root = new JSONObject();
        root.put("id", (Object)workspace.getWorkspaceId());
        root.put("type", (Object)workspace.getWorkspaceType());
        LinkedList<JSONObject> covenants = new LinkedList<JSONObject>();
        for (String covenant : workspace.getCovenants()) {
            JSONObject conv = new JSONObject();
            conv.put("code", (Object)covenant);
            covenants.add(conv);
        }
        root.put("covenants", covenants);
        root.put("description", (Object)workspace.getDescription());
        root.put("bankSlipBillingWebhookActive", (Object)workspace.getBankSlipBillingWebhookActive());
        root.put("pixBillingWebhookActive", (Object)workspace.getPixBillingWebhookActive());
        root.put("webhookURL", (Object)workspace.getWebhookURL());
        return root.toString();
    }

    @Override
    public Workspace toObject(String json, EnvironmentType environmentType) throws BankException {
        JsonNode root = this.getRoot(json);
        return this.textToWorkspace(root, environmentType);
    }

    @Override
    public String toText(WorkspaceDeleteParams params, EnvironmentType environmentType) throws BankException {
        return "";
    }

    @Override
    public String toText(WorkspaceListAllParams params, EnvironmentType environmentType) throws BankException {
        return "";
    }

    @Override
    public WorkspaceListAll toObjectListAll(String text, EnvironmentType environmentType) throws BankException {
        WorkspaceListAll aux = new WorkspaceListAll();
        JsonNode root = this.getRoot(text);
        List<JsonNode> content = this.asList(root, "content");
        LinkedList<Workspace> temp = new LinkedList<Workspace>();
        for (JsonNode jsonNode : content) {
            temp.add(this.textToWorkspace(jsonNode, environmentType));
        }
        aux.setWorkspaces(temp);
        return aux;
    }

    @Override
    public String toText(WorkspaceListParams params, EnvironmentType environmentType) throws BankException {
        return "";
    }
}

