/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.workspace.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessBooleanResult;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.WorkspaceConverter;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.WorkspaceInterface;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.WorkspaceURL;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.WorkspaceValid;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.impl.santander.SantanderValidWorkspaceImpl;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.impl.santander.SantanderWorkspaceConverterImpl;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.impl.santander.SantanderWorkspaceURLImpl;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.Workspace;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceDeleteParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListAll;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceParams;

public class SantanderWorkspaceImpl
extends SantanderBaseConnection
implements WorkspaceInterface {
    private final SantanderWorkspaceConverterImpl converter = new SantanderWorkspaceConverterImpl();
    private final WorkspaceURL urlConverter = new SantanderWorkspaceURLImpl();
    private final WorkspaceValid validator = new SantanderValidWorkspaceImpl();

    @Override
    public ProcessResult<WorkspaceParams, Workspace> createWorkspace(WorkspaceParams params) throws BankException {
        Workspace ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getCreate(params);
            String workspaceText = this.converter.toText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePostData(params.getToken(), url, workspaceText);
            if (res.isOk()) {
                ret = this.converter.toObject(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<WorkspaceParams, Object>(params, ret, res);
        }
        return new ProcessResult<WorkspaceParams, Workspace>(params, contraintValidation);
    }

    @Override
    public ProcessResult<WorkspaceParams, Workspace> update(WorkspaceParams params) throws BankException {
        Workspace ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getUpdate(params);
            String workspaceText = this.converter.toText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePatchData(params.getToken(), url, workspaceText);
            if (res.isOk()) {
                ret = this.converter.toObject(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<WorkspaceParams, Object>(params, ret, res);
        }
        return new ProcessResult<WorkspaceParams, Workspace>(params, contraintValidation);
    }

    @Override
    public ProcessBooleanResult<WorkspaceDeleteParams> delete(WorkspaceDeleteParams params) throws BankException {
        String url = this.urlConverter.getDelete(params);
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        boolean ret = false;
        if (contraintValidation.isValid()) {
            ResponseResult res = this.exchangeDeleteData(params.getToken(), url);
            ret = res.isOk();
        }
        return new ProcessBooleanResult<WorkspaceDeleteParams>(params, ret);
    }

    @Override
    public ProcessResult<WorkspaceListAllParams, WorkspaceListAll> listAll(WorkspaceListAllParams params) throws BankException {
        WorkspaceListAll ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListAll(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectListAll(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<WorkspaceListAllParams, Object>(params, ret, res);
        }
        return new ProcessResult<WorkspaceListAllParams, WorkspaceListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<WorkspaceListParams, Workspace> list(WorkspaceListParams params) throws BankException {
        Workspace ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getList(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObject(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<WorkspaceListParams, Object>(params, ret, res);
        }
        return new ProcessResult<WorkspaceListParams, Workspace>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        return this.getToken(credentials, this.urlConverter.getAuth(credentials));
    }

    @Override
    public WorkspaceConverter getConverter() {
        return this.converter;
    }
}

