/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.billing.workspace.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.WorkspaceURL;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceDeleteParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListAllParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceListParams;
import com.touchcomp.basementorbanks.services.impl.billing.workspace.model.WorkspaceParams;
import com.touchcomp.basementorbanks.url.WorkspaceURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Optional;

public class SantanderWorkspaceURLImpl
implements WorkspaceURL {
    @Override
    public String getCreate(WorkspaceParams params) {
        WorkspaceURLInterface workspaceUrl = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return workspaceUrl.getWorkspaceCreation();
    }

    @Override
    public String getUpdate(WorkspaceParams params) {
        WorkspaceURLInterface workspaceUrl = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(workspaceUrl.getWorkspaceUpdate(), params.getWorkspaceId());
    }

    @Override
    public String getDelete(WorkspaceDeleteParams params) {
        WorkspaceURLInterface workspaceUrl = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(workspaceUrl.getWorkspaceDelete(), params.getWorkspaceId());
    }

    @Override
    public String getList(WorkspaceListParams params) {
        WorkspaceURLInterface workspaceUrl = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        return UtilMethods.formatMessage(workspaceUrl.getWorkspaceDelete(), params.getWorkspaceId());
    }

    @Override
    public String getListAll(WorkspaceListAllParams params) {
        WorkspaceURLInterface workspaceUrl = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(workspaceUrl.getWorkspaceListAll(), new Object[0]);
        return UriComponentsBuilder.from(url).queryParamIfPresent("_limit", Optional.ofNullable(params.getLimit())).queryParamIfPresent("_offset", Optional.ofNullable(params.getOffset())).queryParamIfPresent("_sort", Optional.ofNullable(params.getSort())).build();
    }

    private WorkspaceURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getWorkspaceURL();
        }
        return new SantanderHomoURL().getWorkspaceURL();
    }

    @Override
    public String getAuth(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }
}

