/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.agreement.impl.santander;

import com.touchcomp.basementorbanks.constants.DocumentType;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.Pageable;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.AgreementConverter;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.Agreement;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementConfirmationParams;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementListAll;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementParams;
import com.touchcomp.basementorbanks.util.UtilDate;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.JsonNode;
import org.json.JSONObject;

public class SantanderAgreementConverter
extends BankJsonConverter
implements AgreementConverter {
    private Agreement convertNode(JsonNode root, EnvironmentType environmentType) {
        JsonNode transaction;
        JsonNode beneficaryNode;
        Agreement ag = new Agreement();
        ag.setWorkspaceId(this.asText(root, "workspaceId"));
        ag.setAgreementId(this.asText(root, "id"));
        ag.setCode(this.asText(root, "code"));
        ag.setStatus(this.asText(root, "status"));
        ag.setRejectReason(this.asText(root, "rejectReason"));
        ag.setPaymentType(this.asText(root, "paymentType"));
        ag.setAccountingDate(this.asLocalDate(root, "accountingDate", UtilDate.Mask.TRACE_FORMATTER));
        ag.setTotalValue(this.asDouble(root, "totalValue"));
        ag.setTags(this.asStringList(root, "tags"));
        JsonNode payerNode = root.findValue("finalPayer");
        if (payerNode != null) {
            Agreement.Payer payer = new Agreement.Payer();
            payer.setName(this.asText(payerNode, "name"));
            String documentType = this.asText(payerNode, "documentType");
            if (Objects.equals(documentType, "CPF")) {
                payer.setDocumentType(DocumentType.CPF);
            } else {
                payer.setDocumentType(DocumentType.CNPJ);
            }
            payer.setDocumentNumber(this.asText(payerNode, "documentNumber"));
            ag.setFinalPayer(payer);
        }
        if ((beneficaryNode = root.findValue("concessionary")) != null) {
            Agreement.Concessionary concessionary = new Agreement.Concessionary();
            concessionary.setName(this.asText(payerNode, "name"));
            String documentType = this.asText(payerNode, "documentType");
            if (Objects.equals(documentType, "CPF")) {
                concessionary.setDocumentType(DocumentType.CPF);
            } else {
                concessionary.setDocumentType(DocumentType.CNPJ);
            }
            concessionary.setDocumentNumber(this.asText(payerNode, "documentNumber"));
            ag.setConcessionary(concessionary);
        }
        if ((transaction = root.findValue("transaction")) != null) {
            Double valueTransaction = this.asDouble(transaction, "value");
            String codeTransaction = this.asText(transaction, "code");
            LocalDateTime dateTransaction = this.asLocalDateTime(transaction, "date");
            Agreement.Transaction acc = new Agreement.Transaction();
            acc.setValue(valueTransaction);
            acc.setTransactionCode(codeTransaction);
            acc.setTransactionDate(dateTransaction);
            ag.setTransaction(acc);
        }
        return ag;
    }

    @Override
    public String objectToText(AgreementParams params, EnvironmentType environmentType) {
        JSONObject root = new JSONObject();
        root.put("id", (Object)params.getAgreementId());
        root.put("code", (Object)params.getCode());
        root.put("tags", params.getTags());
        root.put("paymentDate", (Object)UtilDate.dateToStr(params.getPaymentDate(), UtilDate.Mask.TRACE_FORMATTER));
        return root.toString();
    }

    @Override
    public Agreement textToAgreement(String data, EnvironmentType environmentType) throws BankException {
        JsonNode root = this.getRoot(data);
        return this.convertNode(root, environmentType);
    }

    @Override
    public AgreementListAll textToAgreementListAll(String json, EnvironmentType environmentType) throws BankException {
        AgreementListAll aux = new AgreementListAll();
        JsonNode root = this.getRoot(json);
        Pageable page = new Pageable();
        page.setOffset(this.asInt(root, "_offset"));
        page.setPageNumber(this.asInt(root, "_pageNumber"));
        page.setPageElements(this.asInt(root, "_pageElements"));
        page.setTotalPages(this.asInt(root, "_totalPages"));
        page.setTotalElements(this.asInt(root, "_totalElements"));
        aux.setPageable(page);
        List<JsonNode> content = this.asList(root, "_content");
        LinkedList<Agreement> temp = new LinkedList<Agreement>();
        for (JsonNode jsonNode : content) {
            temp.add(this.convertNode(jsonNode, environmentType));
        }
        aux.setAgreements(temp);
        return aux;
    }

    @Override
    public String objectToText(AgreementConfirmationParams params, EnvironmentType environmentType) throws BankException {
        JSONObject acc;
        JSONObject root = new JSONObject();
        root.put("paymentValue", (Object)params.getPaymentValue());
        if (params.getDebitAccount() != null) {
            acc = new JSONObject();
            acc.put("branch", (Object)params.getDebitAccount().getBranch());
            acc.put("number", (Object)params.getDebitAccount().getNumber());
            root.put("debitAccount", (Object)acc);
        }
        if (params.getFinalPayer() != null) {
            acc = new JSONObject();
            acc.put("name", (Object)params.getFinalPayer().getName());
            acc.put("documentType", (Object)params.getFinalPayer().getDocumentType());
            acc.put("documentNumber", (Object)params.getFinalPayer().getDocumentNumber());
            root.put("finalPayer", (Object)acc);
        }
        root.put("status", (Object)params.getStatusType());
        return root.toString();
    }
}

