/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.agreement.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.AgreementConverter;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.AgreementInterface;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.AgreementURL;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.AgreementValid;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.impl.santander.SantanderAgreementConverter;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.impl.santander.SantanderAgreementURLImpl;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.impl.santander.SantanderValidAgreementImpl;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.Agreement;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementConfirmationParams;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementListAll;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementListParams;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementParams;

public class SantanderAgreementImpl
extends SantanderBaseConnection
implements AgreementInterface {
    private final AgreementConverter converter = new SantanderAgreementConverter();
    private final AgreementURL urlConverter = new SantanderAgreementURLImpl();
    private final AgreementValid validator = new SantanderValidAgreementImpl();

    @Override
    public ProcessResult<AgreementParams, Agreement> create(AgreementParams params) throws BankException {
        Agreement ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getCreateUrl(params);
            String body = this.converter.objectToText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.textToAgreement(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<AgreementParams, Object>(params, ret, res);
        }
        return new ProcessResult<AgreementParams, Agreement>(params, contraintValidation);
    }

    @Override
    public ProcessResult<AgreementConfirmationParams, Agreement> confirm(AgreementConfirmationParams params) throws BankException {
        Agreement ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getConfirmUrl(params);
            String body = this.converter.objectToText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePatchData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.textToAgreement(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<AgreementConfirmationParams, Object>(params, ret, res);
        }
        return new ProcessResult<AgreementConfirmationParams, Agreement>(params, contraintValidation);
    }

    @Override
    public ProcessResult<AgreementListParams, Agreement> list(AgreementListParams params) throws BankException {
        Agreement ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToAgreement(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<AgreementListParams, Object>(params, ret, res);
        }
        return new ProcessResult<AgreementListParams, Agreement>(params, contraintValidation);
    }

    @Override
    public ProcessResult<AgreementListAllParams, AgreementListAll> listAll(AgreementListAllParams params) throws BankException {
        AgreementListAll ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListAllUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToAgreementListAll(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<AgreementListAllParams, Object>(params, ret, res);
        }
        return new ProcessResult<AgreementListAllParams, AgreementListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        String urlConfig = this.urlConverter.getAuthUrl(credentials);
        return this.getToken(credentials, urlConfig);
    }
}

