/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.agreement.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.AgreementURL;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementConfirmationParams;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementListParams;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementParams;
import com.touchcomp.basementorbanks.url.AgreementURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Optional;

public class SantanderAgreementURLImpl
implements AgreementURL {
    private AgreementURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getAgreementURL();
        }
        return new SantanderHomoURL().getAgreementURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getCreateUrl(AgreementParams params) {
        AgreementURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getCreationUrl(), params.getWorkspaceId());
        return url;
    }

    @Override
    public String getConfirmUrl(AgreementConfirmationParams params) {
        AgreementURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getConfirmUrl(), params.getWorkspaceId(), params.getAgreementPaymentId());
        return url;
    }

    @Override
    public String getListUrl(AgreementListParams params) {
        AgreementURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getListUrl(), params.getWorkspaceId(), params.getAgreementPaymentId());
        return url;
    }

    @Override
    public String getListAllUrl(AgreementListAllParams params) {
        AgreementURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getListAllUrl(), params.getWorkspaceId());
        url = UriComponentsBuilder.from(url).queryParamIfPresent("_limit", Optional.ofNullable(params.getLimit())).queryParamIfPresent("_offset", Optional.ofNullable(params.getOffset())).queryParamIfPresent("_sort", Optional.ofNullable(params.getSort())).queryParamIfPresent("initialDate", Optional.ofNullable(params.getInitialDate())).queryParamIfPresent("finalDate", Optional.ofNullable(params.getFinalDate())).queryParamIfPresent("status", Optional.ofNullable(params.getStatusType())).build();
        return url;
    }
}

