/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.agreement.impl.santander;

import am.ik.yavi.builder.ValidatorBuilder;
import am.ik.yavi.constraint.CharSequenceConstraint;
import am.ik.yavi.constraint.DoubleConstraint;
import am.ik.yavi.constraint.EnumConstraint;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.Validator;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.AgreementValid;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementConfirmationParams;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementListParams;
import com.touchcomp.basementorbanks.services.impl.payments.agreement.model.AgreementParams;

public class SantanderValidAgreementImpl
implements AgreementValid {
    private Validator<BankToken> getTokenValidation() {
        Validator bankCredentials = ValidatorBuilder.of(BankCredentials.class).constraint(BankCredentials::getEnvironmentType, "environmentType", c -> (EnumConstraint)c.notNull()).build();
        return ValidatorBuilder.of(BankToken.class).constraint(BankToken::getToken, "token", c -> c.notBlank()).nest(BankToken::getBankCredentials, "bankCredentials", bankCredentials).build();
    }

    @Override
    public ConstraintViolations isValid(AgreementParams params) {
        Validator validator = ValidatorBuilder.of(AgreementParams.class).constraint(AgreementParams::getCode, "code", c -> (CharSequenceConstraint)c.notNull()).nest(AgreementParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(AgreementConfirmationParams params) {
        Validator payer = ValidatorBuilder.of(AgreementConfirmationParams.Payer.class).constraint(AgreementConfirmationParams.Payer::getDocumentNumber, "documentNumber", c -> (CharSequenceConstraint)c.notNull()).constraint(AgreementConfirmationParams.Payer::getDocumentType, "documentType", c -> (EnumConstraint)c.notNull()).constraint(AgreementConfirmationParams.Payer::getName, "name", c -> (CharSequenceConstraint)c.notNull()).build();
        Validator validator = ValidatorBuilder.of(AgreementConfirmationParams.class).constraint(AgreementConfirmationParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).constraint(AgreementConfirmationParams::getAgreementPaymentId, "agreementPaymentId", c -> (CharSequenceConstraint)c.notNull()).constraint(AgreementConfirmationParams::getPaymentValue, "paymentValue", c -> (DoubleConstraint)c.notNull()).constraint(AgreementConfirmationParams::getStatusType, "statusType", c -> (CharSequenceConstraint)c.notNull()).nest(AgreementConfirmationParams::getToken, "bankToken", this.getTokenValidation()).nest(AgreementConfirmationParams::getFinalPayer, "finalPayer", payer).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(AgreementListParams params) {
        Validator validator = ValidatorBuilder.of(AgreementListParams.class).constraint(AgreementListParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).constraint(AgreementListParams::getAgreementPaymentId, "agreementPaymentId", c -> (CharSequenceConstraint)c.notNull()).nest(AgreementListParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(AgreementListAllParams params) {
        Validator validator = ValidatorBuilder.of(AgreementListAllParams.class).constraint(AgreementListAllParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).nest(AgreementListAllParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }
}

