/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.dda.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.Pageable;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.payments.dda.DDAConverter;
import com.touchcomp.basementorbanks.services.impl.payments.dda.model.DDA;
import com.touchcomp.basementorbanks.services.impl.payments.dda.model.DDAParams;
import com.touchcomp.basementorbanks.util.UtilDate;
import java.io.IOException;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class SantanderDDAConverter
extends BankJsonConverter
implements DDAConverter {
    @Override
    public DDA toObject(String body, EnvironmentType environmentType) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            DDA aux = new DDA();
            JsonNode root = mapper.readTree(body);
            JsonNode pageableNode = root.findValue("_pageable");
            Integer offset = this.asInt(pageableNode, "_offset");
            Integer pageNumber = this.asInt(pageableNode, "_pageNumber");
            Integer pageElements = this.asInt(pageableNode, "_pageElements");
            Integer totalPages = this.asInt(pageableNode, "_totalPages");
            Integer totalElements = this.asInt(pageableNode, "_totalElements");
            Pageable page = new Pageable();
            page.setOffset(offset);
            page.setPageElements(pageElements);
            page.setPageNumber(pageNumber);
            page.setTotalElements(totalElements);
            page.setTotalPages(totalPages);
            aux.setPageable(page);
            List<JsonNode> pays = this.asList(root, "_content");
            LinkedList<DDA.Title> data = new LinkedList<DDA.Title>();
            for (JsonNode pay : pays) {
                JsonNode finalBeneficiaryNode;
                LocalDate dueDate = this.asLocalDate(pay, "dueDate", UtilDate.Mask.TRACE_FORMATTER);
                String code = this.asText(pay, "code");
                LocalDate paymentLimitDate = this.asLocalDate(pay, "paymentLimitDate", UtilDate.Mask.TRACE_FORMATTER);
                String payerDocumentNumber = this.asText(pay, "payerDocumentNumber");
                Double nominalValue = this.asDouble(pay, "nominalValue");
                DDA.Title title = new DDA.Title();
                title.setDueDate(dueDate);
                title.setCode(code);
                title.setPaymentLimitDate(paymentLimitDate);
                title.setPayerDocumentNumber(payerDocumentNumber);
                title.setNominalValue(nominalValue);
                JsonNode beneficiaryNode = root.findValue("beneficiary");
                if (beneficiaryNode != null) {
                    String documentType = this.asText(beneficiaryNode, "documentType");
                    String documentNumber = this.asText(beneficiaryNode, "documentNumber");
                    String name = this.asText(beneficiaryNode, "name");
                    DDA.Beneficiary beneficiary = new DDA.Beneficiary();
                    beneficiary.setDocumentType(documentType);
                    beneficiary.setDocumentNumber(documentNumber);
                    beneficiary.setName(name);
                    title.setBeneficiary(beneficiary);
                }
                if ((finalBeneficiaryNode = root.findValue("finalBeneficiary")) == null) continue;
                String documentType = this.asText(finalBeneficiaryNode, "documentType");
                String documentNumber = this.asText(finalBeneficiaryNode, "documentNumber");
                String name = this.asText(finalBeneficiaryNode, "name");
                DDA.Beneficiary beneficiary = new DDA.Beneficiary();
                beneficiary.setDocumentType(documentType);
                beneficiary.setDocumentNumber(documentNumber);
                beneficiary.setName(name);
                title.setBeneficiary(beneficiary);
            }
            aux.setTitles(data);
            return aux;
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    @Override
    public String toText(DDAParams params, EnvironmentType environmentType) throws BankException {
        return "";
    }
}

