/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.dda.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.payments.dda.DDAConverter;
import com.touchcomp.basementorbanks.services.impl.payments.dda.DDAInterface;
import com.touchcomp.basementorbanks.services.impl.payments.dda.DDAURL;
import com.touchcomp.basementorbanks.services.impl.payments.dda.DDAValid;
import com.touchcomp.basementorbanks.services.impl.payments.dda.impl.santander.SantanderDDAConverter;
import com.touchcomp.basementorbanks.services.impl.payments.dda.impl.santander.SantanderDDAURLImpl;
import com.touchcomp.basementorbanks.services.impl.payments.dda.impl.santander.SantanderValidDDAImpl;
import com.touchcomp.basementorbanks.services.impl.payments.dda.model.DDA;
import com.touchcomp.basementorbanks.services.impl.payments.dda.model.DDAParams;
import com.touchcomp.basementorbanks.url.DDAURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;

public class SantanderDDAImpl
extends SantanderBaseConnection
implements DDAInterface {
    private final DDAConverter converter = new SantanderDDAConverter();
    private final DDAURL urlConverter = new SantanderDDAURLImpl();
    private final DDAValid valid = new SantanderValidDDAImpl();

    public DDAURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getDdaURL();
        }
        return new SantanderHomoURL().getDdaURL();
    }

    @Override
    public ProcessResult<DDAParams, DDA> getSlips(DDAParams params) throws BankException {
        String url = this.urlConverter.getDDAUrl(params);
        DDA ret = null;
        ConstraintViolations contraintValidation = this.valid.isValid(params);
        if (contraintValidation.isValid()) {
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObject(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<DDAParams, Object>(params, ret, res);
        }
        return new ProcessResult<DDAParams, DDA>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        DDAURLInterface urlConfig = this.getUrl(credentials.getEnvironmentType());
        return this.getToken(credentials, urlConfig.getAuthUrl());
    }
}

