/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.dda.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.payments.dda.DDAURL;
import com.touchcomp.basementorbanks.services.impl.payments.dda.model.DDAParams;
import com.touchcomp.basementorbanks.url.DDAURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilDate;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Optional;

public class SantanderDDAURLImpl
implements DDAURL {
    private DDAURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getDdaURL();
        }
        return new SantanderHomoURL().getDdaURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getDDAUrl(DDAParams params) {
        DDAURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getDdaUrl(), params.getWorkspaceId());
        UriComponentsBuilder builder = UriComponentsBuilder.from(url).queryParamIfPresent("_limit", Optional.ofNullable(params.getLimitRegs())).queryParamIfPresent("_offset", Optional.ofNullable(params.getOffset())).queryParamIfPresent("_sort", Optional.ofNullable(params.getOrder())).queryParamIfPresent("bankNumber", Optional.ofNullable(params.getBankNumber())).queryParamIfPresent("beneficiaryDocument", Optional.ofNullable(params.getBeneficiaryDocument())).queryParamIfPresent("initialDueDate", Optional.ofNullable(UtilDate.dateToStr(params.getInitialDueDate(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("finalDueDate", Optional.ofNullable(UtilDate.dateToStr(params.getFinalDueDate(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("initialIssueDate", Optional.ofNullable(UtilDate.dateToStr(params.getInitialIssueDate(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("finalIssueDate", Optional.ofNullable(UtilDate.dateToStr(params.getFinalIssueDate(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("initialValue", Optional.ofNullable(params.getInitialValue())).queryParamIfPresent("finalValue", Optional.ofNullable(params.getFinalValue())).queryParamIfPresent("beneficiaryDocument", Optional.ofNullable(params.getBeneficiaryDocument())).queryParamIfPresent("titleSituation", Optional.ofNullable(params.getTitleSituationType()));
        return builder.build();
    }
}

