/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.pix.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.Pageable;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.payments.pix.PixPayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPay;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayParams;
import com.touchcomp.basementorbanks.util.UtilDate;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;

public class SantanderPixPayConverter
extends BankJsonConverter
implements PixPayConverter {
    @Override
    public PixPay toObjectPixPay(String body, EnvironmentType environmentType) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(body);
            return this.nodeToBankPixPay(root);
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    @Override
    public PixPayListAll toObjectPixPayListAll(String body, EnvironmentType environmentType) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            PixPayListAll aux = new PixPayListAll();
            JsonNode root = mapper.readTree(body);
            JsonNode pageableNode = root.findValue("_pageable");
            Integer offset = this.asInt(pageableNode, "_offset");
            Integer pageNumber = this.asInt(pageableNode, "_pageNumber");
            Integer pageElements = this.asInt(pageableNode, "_pageElements");
            Integer totalPages = this.asInt(pageableNode, "_totalPages");
            Integer totalElements = this.asInt(pageableNode, "_totalElements");
            Pageable page = new Pageable();
            page.setOffset(offset);
            page.setPageElements(pageElements);
            page.setPageNumber(pageNumber);
            page.setTotalElements(totalElements);
            page.setTotalPages(totalPages);
            aux.setPageable(page);
            List<JsonNode> pays = this.asList(root, "_content");
            LinkedList<PixPay> data = new LinkedList<PixPay>();
            for (JsonNode pay : pays) {
                data.add(this.nodeToBankPixPay(pay));
            }
            aux.setContent(data);
            return aux;
        }
        catch (IOException ex) {
            throw new BankException(ex);
        }
    }

    private PixPay nodeToBankPixPay(JsonNode root) {
        JsonNode transaction;
        JsonNode beneficiary;
        PixPay aux = new PixPay();
        String id = root.findValue("id").asText();
        aux.setId(id);
        JsonNode debitAccount = root.findValue("debitAccount");
        if (debitAccount != null) {
            String branch = this.asText(debitAccount, "branch");
            String number = this.asText(debitAccount, "number");
            PixPay.Account acc = new PixPay.Account();
            acc.setBranch(branch);
            acc.setNumber(number);
            aux.setDebitAccount(acc);
        }
        String status = this.asText(root, "status");
        String rejectCode = this.asText(root, "rejectCode");
        String rejectReason = this.asText(root, "rejectReason");
        List<String> tags = this.asStringList(root, "tags");
        String dictCodeType = this.asText(root, "dictCodeType");
        String dictCode = this.asText(root, "dictCode");
        String qrCode = this.asText(root, "qrCode");
        String ibgeTownCode = this.asText(root, "ibgeTownCode");
        LocalDate paymentDate = this.asLocalDate(root, "paymentDate", UtilDate.Mask.TRACE_FORMATTER);
        String qrCodeIdentification = this.asText(root, "qrCodeIdentification");
        String remittanceInformation = this.asText(root, "remittanceInformation");
        LocalDate dueDate = this.asLocalDate(root, "dueDate", UtilDate.Mask.TRACE_FORMATTER);
        Double nominalValue = this.asDouble(root, "nominalValue");
        Double deductedValue = this.asDouble(root, "deductedValue");
        Double addedValue = this.asDouble(root, "addedValue");
        Double totalValue = this.asDouble(root, "totalValue");
        aux.setAddedValue(addedValue);
        aux.setDeductedValue(deductedValue);
        aux.setDictCode(dictCode);
        aux.setDictCodeType(dictCodeType);
        aux.setDueDate(dueDate);
        aux.setIbgeTownCode(ibgeTownCode);
        aux.setNominalValue(nominalValue);
        aux.setPaymentDate(paymentDate);
        aux.setQrCode(qrCode);
        aux.setQrCodeIdentification(qrCodeIdentification);
        aux.setRejectReason(rejectReason);
        aux.setRejectCode(rejectCode);
        aux.setRemittanceInformation(remittanceInformation);
        aux.setStatusType(status);
        aux.setTags(tags);
        aux.setTotalValue(totalValue);
        JsonNode payer = root.findValue("payer");
        if (payer != null) {
            String name = payer.findValue("name").asText();
            String documentType = payer.findValue("documentType").asText();
            String documentNumber = payer.findValue("documentNumber").asText();
            PixPay.Payer acc = new PixPay.Payer();
            acc.setDocumentNumber(documentNumber);
            acc.setDocumentType(documentType);
            acc.setName(name);
            aux.setPayer(acc);
        }
        if ((beneficiary = root.findValue("beneficiary")) != null) {
            String branch = this.asText(beneficiary, "branch");
            String ispb = this.asText(beneficiary, "ispb");
            String number = this.asText(beneficiary, "number");
            String type = this.asText(beneficiary, "type");
            String documentType = this.asText(beneficiary, "documentType");
            String documentNumber = this.asText(beneficiary, "documentNumber");
            String name = this.asText(beneficiary, "name");
            String bankCode = this.asText(beneficiary, "bankCode");
            PixPay.Beneficiary acc = new PixPay.Beneficiary();
            acc.setBranch(branch);
            acc.setAccountNumber(number);
            acc.setIspb(ispb);
            acc.setAccountType(type);
            acc.setBankCode(bankCode);
            acc.setDocumentNumber(documentNumber);
            acc.setDocumentType(documentType);
            acc.setName(name);
            aux.setBeneficiary(acc);
        }
        if ((transaction = root.findValue("transaction")) != null) {
            Double valueTransaction = this.asDouble(transaction, "value");
            String codeTransaction = this.asText(transaction, "code");
            LocalDateTime dateTransaction = this.asLocalDateTime(transaction, "date");
            String endToend = this.asText(transaction, "endToEnd");
            PixPay.Transaction acc = new PixPay.Transaction();
            acc.setValue(valueTransaction);
            acc.setCode(codeTransaction);
            acc.setTransactionDate(dateTransaction);
            acc.setEndToEnd(endToend);
            aux.setTransaction(acc);
        }
        return aux;
    }

    @Override
    public String toText(PixPayParams vo, EnvironmentType environmentType) {
        JSONObject root = new JSONObject();
        root.put("id", (Object)vo.getPixPaymentId());
        root.put("remittanceInformation", (Object)vo.getRemittanceInformation());
        root.put("paymentValue", (Object)vo.getPaymentValue());
        if (vo.getBeneficiary() != null) {
            JSONObject beneficiary = new JSONObject();
            beneficiary.put("branch", (Object)vo.getBeneficiary().getBranchNumber());
            beneficiary.put("number", (Object)vo.getBeneficiary().getAccountNumber());
            beneficiary.put("type", (Object)vo.getBeneficiary().getAccountType());
            beneficiary.put("documentType", (Object)vo.getBeneficiary().getDocumentType());
            beneficiary.put("documentNumber", (Object)vo.getBeneficiary().getDocumentNumber());
            beneficiary.put("name", (Object)vo.getBeneficiary().getName());
            beneficiary.put("bankCode", (Object)vo.getBeneficiary().getBankCode());
            beneficiary.put("isp", (Object)vo.getBeneficiary().getIspb());
            root.put("beneficiary", (Object)beneficiary);
        } else if (vo.getQrCodePay() != null) {
            root.put("qrCode", (Object)vo.getQrCodePay().getQrCode());
            root.put("ibgeTownCode", (Object)vo.getQrCodePay().getIbgeTownCode());
            root.put("paymentDate", (Object)UtilDate.dateToStr(vo.getQrCodePay().getPaymentDate(), UtilDate.Mask.TRACE_FORMATTER));
        } else if (vo.getDictPay() != null) {
            root.put("dictCode", (Object)vo.getDictPay().getDictCode());
            root.put("dictCodeType", (Object)vo.getDictPay().getDictCodeType());
        }
        return root.toString();
    }

    @Override
    public String toTextConfirm(PixPayParams vo, EnvironmentType environmentType) throws BankException {
        JSONObject root = new JSONObject();
        root.put("paymentValue", (Object)vo.getPaymentValue());
        root.put("status", (Object)vo.getStatusType());
        if (vo.getDebitAccount() != null) {
            JSONObject account = new JSONObject();
            account.put("branch", (Object)vo.getDebitAccount().getBranch());
            account.put("number", (Object)vo.getDebitAccount().getNumber());
            root.put("debitAccount", (Object)account);
        }
        return root.toString();
    }
}

