/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.pix.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.payments.pix.PixPayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.pix.PixPayInterface;
import com.touchcomp.basementorbanks.services.impl.payments.pix.PixPayURL;
import com.touchcomp.basementorbanks.services.impl.payments.pix.PixPayValid;
import com.touchcomp.basementorbanks.services.impl.payments.pix.impl.santander.SantanderPixPayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.pix.impl.santander.SantanderPixPayURLImpl;
import com.touchcomp.basementorbanks.services.impl.payments.pix.impl.santander.SantanderValidPixPayImpl;
import com.touchcomp.basementorbanks.services.impl.payments.pix.impl.santander.constants.SantanderPixPayStatusType;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPay;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayParams;

public class SantanderPixPayImpl
extends SantanderBaseConnection
implements PixPayInterface {
    private final PixPayConverter converter = new SantanderPixPayConverter();
    private final PixPayURL urlConverter = new SantanderPixPayURLImpl();
    private final PixPayValid validator = new SantanderValidPixPayImpl();

    @Override
    public ProcessResult<PixPayParams, PixPay> create(PixPayParams params) throws BankException {
        PixPay ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getCreateUrl(params);
            String body = this.converter.toText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            if (!res.isOk()) {
                return new ProcessResult<PixPayParams, PixPay>(res);
            }
            ret = this.converter.toObjectPixPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            params.setStatusType(SantanderPixPayStatusType.AUTHORIZED.getValue());
            url = this.urlConverter.getConfirmUrl(params);
            body = this.converter.toTextConfirm(params, params.getToken().getBankCredentials().getEnvironmentType());
            res = this.exchangePatchData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.toObjectPixPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<PixPayParams, PixPay>(params, ret, res);
        }
        return new ProcessResult<PixPayParams, PixPay>(params, contraintValidation);
    }

    @Override
    public ProcessResult<PixPayListParams, PixPay> list(PixPayListParams params) throws BankException {
        PixPay ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectPixPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<PixPayListParams, Object>(params, ret, res);
        }
        return new ProcessResult<PixPayListParams, PixPay>(params, contraintValidation);
    }

    @Override
    public ProcessResult<PixPayListAllParams, PixPayListAll> listAll(PixPayListAllParams params) throws BankException {
        PixPayListAll ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListAllUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectPixPayListAll(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<PixPayListAllParams, Object>(params, ret, res);
        }
        return new ProcessResult<PixPayListAllParams, PixPayListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        String urlConfig = this.urlConverter.getAuthUrl(credentials);
        return this.getToken(credentials, urlConfig);
    }
}

