/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.pix.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.payments.pix.PixPayURL;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayParams;
import com.touchcomp.basementorbanks.url.PixPayURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Optional;

public class SantanderPixPayURLImpl
implements PixPayURL {
    private PixPayURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getPixPayURL();
        }
        return new SantanderHomoURL().getPixPayURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getCreateUrl(PixPayParams params) {
        PixPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getCreationPixPay(), params.getWorkspaceId());
        return url;
    }

    @Override
    public String getConfirmUrl(PixPayParams params) {
        PixPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getConfirmPixPay(), params.getWorkspaceId(), params.getPixPaymentId());
        return url;
    }

    @Override
    public String getListUrl(PixPayListParams params) {
        PixPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getPixPayList(), params.getWorkspaceId(), params.getPixPaymentId());
        return url;
    }

    @Override
    public String getListAllUrl(PixPayListAllParams params) {
        PixPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getPixPayListAll(), params.getWorkspaceId());
        url = UriComponentsBuilder.from(url).queryParamIfPresent("_limit", Optional.ofNullable(params.getLimit())).queryParamIfPresent("_offset", Optional.ofNullable(params.getOffset())).queryParamIfPresent("_sort", Optional.ofNullable(params.getSort())).queryParamIfPresent("initialDate", Optional.ofNullable(params.getInitialDate())).queryParamIfPresent("finalDate", Optional.ofNullable(params.getFinalDate())).queryParamIfPresent("status", Optional.ofNullable(params.getStatusType())).build();
        return url;
    }
}

