/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.pix.impl.santander;

import am.ik.yavi.builder.ValidatorBuilder;
import am.ik.yavi.constraint.CharSequenceConstraint;
import am.ik.yavi.constraint.DoubleConstraint;
import am.ik.yavi.constraint.EnumConstraint;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.Validator;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.services.impl.payments.pix.PixPayValid;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.pix.model.PixPayParams;

public class SantanderValidPixPayImpl
implements PixPayValid {
    private Validator<BankToken> getTokenValidation() {
        Validator bankCredentials = ValidatorBuilder.of(BankCredentials.class).constraint(BankCredentials::getEnvironmentType, "environmentType", c -> (EnumConstraint)c.notNull()).build();
        return ValidatorBuilder.of(BankToken.class).constraint(BankToken::getToken, "token", c -> c.notBlank()).nest(BankToken::getBankCredentials, "bankCredentials", bankCredentials).build();
    }

    @Override
    public ConstraintViolations isValid(PixPayParams params) {
        Validator dictPay = ValidatorBuilder.of(PixPayParams.DICTPay.class).constraint(PixPayParams.DICTPay::getDictCodeType, "dictCodeType", c -> (CharSequenceConstraint)c.notNull()).constraint(PixPayParams.DICTPay::getDictCode, "dictCode", c -> (CharSequenceConstraint)c.notNull()).build();
        Validator qrCodePay = ValidatorBuilder.of(PixPayParams.QRCodePay.class).constraint(PixPayParams.QRCodePay::getQrCode, "qrCodePay", c -> (CharSequenceConstraint)c.notNull()).build();
        Validator transfPay = ValidatorBuilder.of(PixPayParams.Beneficiary.class).constraint(PixPayParams.Beneficiary::getName, "name", c -> (CharSequenceConstraint)c.notNull()).constraint(PixPayParams.Beneficiary::getDocumentType, "documentType", c -> (CharSequenceConstraint)c.notNull()).constraint(PixPayParams.Beneficiary::getDocumentNumber, "documentNumber", c -> (CharSequenceConstraint)c.notNull()).constraint(PixPayParams.Beneficiary::getBranchNumber, "branchNumber", c -> (CharSequenceConstraint)c.notNull()).constraint(PixPayParams.Beneficiary::getAccountNumber, "accountNumber", c -> (CharSequenceConstraint)c.notNull()).constraint(PixPayParams.Beneficiary::getAccountType, "accountType", c -> (CharSequenceConstraint)c.notNull()).constraint(PixPayParams.Beneficiary::getIspb, "ispBank", c -> (CharSequenceConstraint)c.notNull()).build();
        ValidatorBuilder validator = ValidatorBuilder.of(PixPayParams.class).constraint(PixPayParams::getPaymentValue, "paymentValue", c -> (DoubleConstraint)c.notNull()).nest(PixPayParams::getToken, "bankToken", this.getTokenValidation());
        if (params.getDictPay() != null) {
            validator.nest(PixPayParams::getDictPay, "dictPay", dictPay);
        } else if (params.getQrCodePay() != null) {
            validator.nest(PixPayParams::getQrCodePay, "qrCodePay", qrCodePay);
        } else {
            validator.nest(PixPayParams::getBeneficiary, "beneficiary", transfPay);
        }
        return validator.build().validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixPayListParams params) {
        Validator validator = ValidatorBuilder.of(PixPayListParams.class).nest(PixPayListParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(PixPayListAllParams params) {
        Validator validator = ValidatorBuilder.of(PixPayListAllParams.class).nest(PixPayListAllParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }
}

