/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.receipts.impl.santander;

import com.touchcomp.basementorbanks.constants.DocumentType;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.ReceiptPayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayFile;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayRequest;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayRequestListAll;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.JsonNode;

public class SantanderReceiptConverter
extends BankJsonConverter
implements ReceiptPayConverter {
    @Override
    public ReceiptPayListAll toObject(String json, EnvironmentType environmentType) throws BankException {
        try {
            ReceiptPayListAll aux = new ReceiptPayListAll();
            JsonNode root = this.getRoot(json);
            List<JsonNode> content = this.asList(root, "paymentsReceipts");
            LinkedList<ReceiptPayListAll.Payment> temp = new LinkedList<ReceiptPayListAll.Payment>();
            for (JsonNode jsonNode1 : content) {
                JsonNode payeeNode;
                JsonNode paymentAmountInfoNode;
                JsonNode channelNode;
                JsonNode payNode = jsonNode1.get("payment");
                ReceiptPayListAll.Payment pay = new ReceiptPayListAll.Payment();
                pay.setCommitmentNumber(this.asText(payNode, "commitmentNumber"));
                pay.setPaymentId(this.asText(payNode, "paymentId"));
                JsonNode categoryNode = jsonNode1.get("category");
                if (categoryNode != null) {
                    pay.setCategoryType(this.asText(categoryNode, "code"));
                }
                if ((channelNode = jsonNode1.get("channel")) != null) {
                    pay.setChannel(this.asText(channelNode, "code"));
                }
                if ((paymentAmountInfoNode = payNode.get("paymentAmountInfo")) != null && paymentAmountInfoNode.get("direct") != null) {
                    JsonNode docNode = paymentAmountInfoNode.get("direct");
                    pay.setValues(new ReceiptPayListAll.Value());
                    pay.getValues().setMainValue(this.asDouble(docNode, "amount"));
                }
                if ((payeeNode = payNode.get("payee")) != null) {
                    pay.setPayee(new ReceiptPayListAll.Payee());
                    pay.getPayee().setName(this.asText(payeeNode, "name"));
                }
                JsonNode payerNode = payNode.get("payer");
                if (payeeNode != null && payerNode.get("person") != null && payerNode.get("person").get("document") != null) {
                    JsonNode docNode = payerNode.get("person").get("document");
                    pay.setPayer(new ReceiptPayListAll.Payer());
                    pay.getPayer().setDocumentNumber(this.asText(docNode, "name"));
                    pay.getPayer().setDocumentType(DocumentType.get(this.asText(docNode, "name")));
                }
                temp.add(pay);
            }
            aux.setPayments(temp);
            return aux;
        }
        catch (BankException ex) {
            throw new BankException(ex);
        }
    }

    @Override
    public ReceiptPayRequest toObjectReceiptPay(String json, EnvironmentType environmentType) throws BankException {
        try {
            JsonNode fileNode;
            ReceiptPayRequest aux = new ReceiptPayRequest();
            JsonNode root = this.getRoot(json);
            JsonNode requestNode = root.get("request");
            if (requestNode != null) {
                aux.setReceiptRequestId(this.asText(requestNode, "requestId"));
                aux.setReceiptRequestDate(this.asLocalDateTime(requestNode, "creationDateTime"));
            }
            if ((fileNode = root.get("file")) != null) {
                aux.setMimeType(this.asText(fileNode, "mimeType"));
                JsonNode fileLocationNode = fileNode.get("file");
                if (fileLocationNode != null) {
                    aux.setLocation(this.asText(fileLocationNode, "location"));
                }
            }
            return aux;
        }
        catch (BankException ex) {
            throw new BankException(ex);
        }
    }

    @Override
    public ReceiptPayFile toObjectReceiptPayFile(String json, EnvironmentType environmentType) throws BankException {
        try {
            JsonNode requestNode;
            ReceiptPayFile aux = new ReceiptPayFile();
            JsonNode root = this.getRoot(json);
            JsonNode fileNode = root.get("file");
            if (fileNode != null) {
                if (fileNode.get("fileRepository") != null) {
                    aux.setFileLocation(this.asText(fileNode.get("fileRepository"), "location"));
                }
                aux.setExpirationDate(this.asLocalDateTime(fileNode, "expirationDate"));
                aux.setMimeType(this.asText(fileNode, "mimeType"));
                if (fileNode.get("statusInfo") != null) {
                    aux.setStatusCode(this.asText(fileNode.get("statusInfo"), "statusCode"));
                }
            }
            if ((requestNode = root.get("request")) != null) {
                aux.setRequestId(this.asText(requestNode, "requestId"));
            }
            return aux;
        }
        catch (BankException ex) {
            throw new BankException(ex);
        }
    }

    @Override
    public ReceiptPayRequestListAll toObjectRequestPay(String json, EnvironmentType environmentType) throws BankException {
        try {
            ReceiptPayRequestListAll aux = new ReceiptPayRequestListAll();
            JsonNode root = this.getRoot(json);
            List<JsonNode> content = this.asList(root, "paymentReceiptsFileRequests");
            LinkedList<ReceiptPayRequestListAll.Request> temp = new LinkedList<ReceiptPayRequestListAll.Request>();
            for (JsonNode jsonNode1 : content) {
                JsonNode fileNode;
                ReceiptPayRequestListAll.Request request = new ReceiptPayRequestListAll.Request();
                JsonNode requestNode = jsonNode1.get("request");
                if (requestNode != null) {
                    request.setRequestId(this.asText(requestNode, "requestId"));
                    request.setCreationDateTime(this.asLocalDateTime(requestNode, "creationDateTime"));
                }
                if ((fileNode = jsonNode1.get("file")) == null) continue;
                request.setMimeType(this.asText(fileNode, "mimeType"));
                request.setExpirationDate(this.asLocalDateTime(fileNode, "expirationDate"));
                if (fileNode.get("fileRepository") != null) {
                    request.setFileLocation(this.asText(fileNode.get("fileRepository"), "location"));
                }
                if (fileNode.get("statusInfo") == null) continue;
                request.setFileLocation(this.asText(fileNode.get("statusInfo"), "statusCode"));
            }
            aux.setRequests(temp);
            return aux;
        }
        catch (BankException ex) {
            throw new BankException(ex);
        }
    }
}

