/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.receipts.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.ReceiptPayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.ReceiptPayInterface;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.ReceiptPayURL;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.ReceiptPayValid;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.impl.santander.SantanderReceiptConverter;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.impl.santander.SantanderReceiptURLImpl;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.impl.santander.SantanderValidReceiptImpl;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayFile;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayFileParams;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayRequest;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayRequestListAll;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayRequestListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayRequestParams;
import com.touchcomp.basementorbanks.url.ReceiptURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;

public class SantanderReceiptImpl
extends SantanderBaseConnection
implements ReceiptPayInterface {
    private final ReceiptPayConverter converter = new SantanderReceiptConverter();
    private final ReceiptPayURL urlConverter = new SantanderReceiptURLImpl();
    private final ReceiptPayValid valid = new SantanderValidReceiptImpl();

    public ReceiptURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getReceiptURL();
        }
        return new SantanderHomoURL().getReceiptURL();
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        ReceiptURLInterface urlConfig = this.getUrl(credentials.getEnvironmentType());
        return this.getToken(credentials, urlConfig.getAuthUrl());
    }

    @Override
    public ProcessResult<ReceiptPayListAllParams, ReceiptPayListAll> listAll(ReceiptPayListAllParams params) throws BankException {
        ReceiptPayListAll ret = null;
        ConstraintViolations contraintValidation = this.valid.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListAllUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObject(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<ReceiptPayListAllParams, Object>(params, ret, res);
        }
        return new ProcessResult<ReceiptPayListAllParams, ReceiptPayListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<ReceiptPayRequestParams, ReceiptPayRequest> createReceipt(ReceiptPayRequestParams params) throws BankException {
        ReceiptPayRequest ret = null;
        ConstraintViolations contraintValidation = this.valid.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getCreateFileUrl(params);
            ResponseResult res = this.exchangePostData(params.getToken(), url, "");
            if (res.isOk()) {
                ret = this.converter.toObjectReceiptPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<ReceiptPayRequestParams, Object>(params, ret, res);
        }
        return new ProcessResult<ReceiptPayRequestParams, ReceiptPayRequest>(params, contraintValidation);
    }

    @Override
    public ProcessResult<ReceiptPayFileParams, ReceiptPayFile> downloadReceipt(ReceiptPayFileParams params) throws BankException {
        ReceiptPayFile ret = null;
        ConstraintViolations contraintValidation = this.valid.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getDownloadFileUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectReceiptPayFile(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<ReceiptPayFileParams, Object>(params, ret, res);
        }
        return new ProcessResult<ReceiptPayFileParams, ReceiptPayFile>(params, contraintValidation);
    }

    @Override
    public ProcessResult<ReceiptPayRequestListAllParams, ReceiptPayRequestListAll> listAllRequests(ReceiptPayRequestListAllParams params) throws BankException {
        ReceiptPayRequestListAll ret = null;
        ConstraintViolations contraintValidation = this.valid.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListAllRequestsUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.toObjectRequestPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<ReceiptPayRequestListAllParams, Object>(params, ret, res);
        }
        return new ProcessResult<ReceiptPayRequestListAllParams, ReceiptPayRequestListAll>(params, contraintValidation);
    }
}

