/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.receipts.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.ReceiptPayURL;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayFileParams;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayRequestListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.receipts.model.ReceiptPayRequestParams;
import com.touchcomp.basementorbanks.url.ReceiptURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilDate;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Optional;

public class SantanderReceiptURLImpl
implements ReceiptPayURL {
    private ReceiptURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getReceiptURL();
        }
        return new SantanderHomoURL().getReceiptURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getListAllUrl(ReceiptPayListAllParams params) {
        ReceiptURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getListAllUrl(), new Object[0]);
        UriComponentsBuilder builder = UriComponentsBuilder.from(url).queryParamIfPresent("_limit", Optional.ofNullable(params.getLimit())).queryParamIfPresent("_offset", Optional.ofNullable(params.getOffset())).queryParamIfPresent("account_agency", Optional.ofNullable(params.getAccounBranch())).queryParamIfPresent("account_number", Optional.ofNullable(params.getAccounNumber())).queryParamIfPresent("start_date", Optional.ofNullable(UtilDate.dateToStr(params.getInitialDate(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("end_date", Optional.ofNullable(UtilDate.dateToStr(params.getFinalDate(), UtilDate.Mask.TRACE_FORMATTER))).queryParamIfPresent("start_time", Optional.ofNullable(UtilDate.dateToStr(params.getInitialDate(), UtilDate.Mask.HOUR_FORMATTER))).queryParamIfPresent("end_time", Optional.ofNullable(UtilDate.dateToStr(params.getFinalDate(), UtilDate.Mask.HOUR_FORMATTER))).queryParamIfPresent("beneficiary_document", Optional.ofNullable(params.getBeneficiaryDocument())).queryParamIfPresent("category", Optional.ofNullable(params.getCategoryType()));
        return builder.build();
    }

    @Override
    public String getCreateFileUrl(ReceiptPayRequestParams params) {
        ReceiptURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getCreateReceiptUrl(), params.getPaymentId());
        return url;
    }

    @Override
    public String getDownloadFileUrl(ReceiptPayFileParams params) {
        ReceiptURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getDownloadReceiptUrl(), params.getPaymentId(), params.getReceiptRequestId());
        return url;
    }

    @Override
    public String getListAllRequestsUrl(ReceiptPayRequestListAllParams params) {
        ReceiptURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getListAllRequestUrl(), params.getPaymentId());
        return url;
    }
}

