/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.slip.impl.santander;

import com.touchcomp.basementorbanks.constants.DocumentType;
import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.Pageable;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.payments.slip.SlipPayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPay;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayParams;
import com.touchcomp.basementorbanks.util.UtilDate;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;

public class SantanderSlipPayConverter
extends BankJsonConverter
implements SlipPayConverter {
    @Override
    public SlipPay textToBankSlipPay(String body, EnvironmentType environmentType) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(body);
            return this.nodeToBankSlipPay(root);
        }
        catch (IOException ex) {
            Logger.getLogger(SantanderSlipPayConverter.class.getName()).log(Level.SEVERE, null, ex);
            throw new BankException(ex);
        }
    }

    @Override
    public SlipPayListAll textToBankSlipListAllPay(String body, EnvironmentType environmentType) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            SlipPayListAll aux = new SlipPayListAll();
            JsonNode root = mapper.readTree(body);
            JsonNode pageableNode = root.findValue("_pageable");
            Integer offset = this.asInt(pageableNode, "_offset");
            Integer pageNumber = this.asInt(pageableNode, "_pageNumber");
            Integer pageElements = this.asInt(pageableNode, "_pageElements");
            Integer totalPages = this.asInt(pageableNode, "_totalPages");
            Integer totalElements = this.asInt(pageableNode, "_totalElements");
            Pageable page = new Pageable();
            page.setOffset(offset);
            page.setPageElements(pageElements);
            page.setPageNumber(pageNumber);
            page.setTotalElements(totalElements);
            page.setTotalPages(totalPages);
            aux.setPageable(page);
            List<JsonNode> pays = this.asList(root, "_content");
            LinkedList<SlipPay> data = new LinkedList<SlipPay>();
            for (JsonNode pay : pays) {
                data.add(this.nodeToBankSlipPay(pay));
            }
            aux.setSlipPay(data);
            return aux;
        }
        catch (IOException ex) {
            Logger.getLogger(SantanderSlipPayConverter.class.getName()).log(Level.SEVERE, null, ex);
            throw new BankException(ex);
        }
    }

    private SlipPay nodeToBankSlipPay(JsonNode root) {
        JsonNode transaction;
        JsonNode partialPayment;
        JsonNode finalBeneficiary;
        JsonNode beneficiary;
        JsonNode finalPayer;
        SlipPay aux = new SlipPay();
        String id = this.asText(root, "id");
        String code = this.asText(root, "code");
        aux.setId(id);
        aux.setCode(code);
        JsonNode debitAccount = root.findValue("debitAccount");
        if (debitAccount != null) {
            SlipPay.Account acc = new SlipPay.Account();
            acc.setBranch(this.asText(debitAccount, "branch"));
            acc.setNumber(this.asText(debitAccount, "number"));
            aux.setDebitAccount(acc);
        }
        aux.setStatusType(this.asText(root, "status"));
        aux.setRejectReason(this.asText(root, "rejectReason"));
        aux.setRejectCode(this.asText(root, "rejectCode"));
        aux.setDueDate(this.asLocalDate(root, "dueDate", UtilDate.Mask.TRACE_FORMATTER));
        aux.setAccountingDate(this.asLocalDate(root, "accountingDate", UtilDate.Mask.TRACE_FORMATTER));
        aux.setNominalValue(this.asDouble(root, "nominalValue"));
        aux.setDeductedValue(this.asDouble(root, "deductedValue"));
        aux.setAddedValue(this.asDouble(root, "addedValue"));
        aux.setTotalValue(this.asDouble(root, "totalValue"));
        aux.setDocumentKind(this.asText(root, "documentKind"));
        aux.setDocumentKindCode(this.asText(root, "documentKindCode"));
        aux.setTags(this.asStringList(root, "tags"));
        aux.setPaymentValue(this.asDouble(root, "paymentValue"));
        JsonNode payer = root.findValue("payer");
        if (payer != null) {
            SlipPay.Payer acc = new SlipPay.Payer();
            acc.setDocumentNumber(this.asText(payer, "documentNumber"));
            acc.setDocumentType(DocumentType.get(this.asText(payer, "documentType")));
            acc.setName(this.asText(payer, "name"));
            aux.setPayer(acc);
        }
        if ((finalPayer = root.findValue("finalPayer")) != null) {
            SlipPay.Payer acc = new SlipPay.Payer();
            acc.setDocumentNumber(this.asText(finalPayer, "documentNumber"));
            acc.setDocumentType(DocumentType.get(this.asText(finalPayer, "documentType")));
            acc.setName(this.asText(finalPayer, "name"));
            aux.setFinalPayer(acc);
        }
        if ((beneficiary = root.findValue("beneficiary")) != null) {
            SlipPay.Beneficiary acc = new SlipPay.Beneficiary();
            acc.setDocumentNumber(this.asText(beneficiary, "documentNumber"));
            acc.setDocumentType(DocumentType.get(this.asText(beneficiary, "documentType")));
            acc.setName(this.asText(beneficiary, "name"));
            aux.setBeneficiary(acc);
        }
        if ((finalBeneficiary = root.findValue("finalBeneficiary")) != null) {
            SlipPay.Beneficiary acc = new SlipPay.Beneficiary();
            acc.setDocumentNumber(this.asText(finalBeneficiary, "documentNumber"));
            acc.setDocumentType(DocumentType.get(this.asText(finalBeneficiary, "documentType")));
            acc.setName(this.asText(finalBeneficiary, "name"));
            aux.setFinalBeneficiary(acc);
        }
        if ((partialPayment = root.findValue("partialPayment")) != null) {
            SlipPay.PartialPayment acc = new SlipPay.PartialPayment();
            acc.setMin(this.asDouble(partialPayment, "min"));
            acc.setMax(this.asDouble(partialPayment, "max"));
            acc.setPayed(this.asDouble(partialPayment, "payed"));
            aux.setPartialPayment(acc);
        }
        if ((transaction = root.findValue("transaction")) != null) {
            SlipPay.Transaction acc = new SlipPay.Transaction();
            acc.setValue(this.asDouble(transaction, "value"));
            acc.setCode(this.asText(transaction, "code"));
            acc.setTransactionDate(this.asLocalDateTime(transaction, "date"));
            aux.setTransaction(acc);
        }
        return aux;
    }

    @Override
    public String objectToText(SlipPayParams vo, EnvironmentType environmentType) throws BankException {
        JSONObject root = new JSONObject();
        root.put("id", (Object)vo.getSlipPaymentId());
        root.put("code", (Object)vo.getCode());
        root.put("paymentDate", (Object)UtilDate.dateToStr(vo.getPaymentDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("tags", vo.getTags());
        return root.toString();
    }

    @Override
    public String objectToTextConfirmation(SlipPayParams vo, EnvironmentType environmentType) throws BankException {
        JSONObject root = new JSONObject();
        root.put("paymentValue", (Object)vo.getPaymentValue());
        if (vo.getDebitAccount() != null) {
            JSONObject debitAccount = new JSONObject();
            debitAccount.put("branch", (Object)vo.getDebitAccount().getBranch());
            debitAccount.put("number", (Object)vo.getDebitAccount().getNumber());
            root.put("debitAccount", (Object)debitAccount);
        }
        if (vo.getFinalPayer() != null) {
            JSONObject finalPayer = new JSONObject();
            finalPayer.put("name", (Object)vo.getFinalPayer().getName());
            if (Objects.equals((Object)DocumentType.CNPJ, (Object)vo.getFinalPayer().getDocumentType())) {
                finalPayer.put("documentType", (Object)"CNPJ");
            } else {
                finalPayer.put("documentType", (Object)"CPF");
            }
            finalPayer.put("documentNumber", (Object)vo.getFinalPayer().getDocumentNumber());
            root.put("finalPayer", (Object)finalPayer);
        }
        root.put("status", (Object)vo.getStatusType());
        return root.toString();
    }
}

