/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.slip.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.payments.slip.SlipPayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.slip.SlipPayInterface;
import com.touchcomp.basementorbanks.services.impl.payments.slip.SlipPayURLConverter;
import com.touchcomp.basementorbanks.services.impl.payments.slip.SlipPayValid;
import com.touchcomp.basementorbanks.services.impl.payments.slip.impl.santander.SantanderSlipPayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.slip.impl.santander.SantanderSlipPayURLImpl;
import com.touchcomp.basementorbanks.services.impl.payments.slip.impl.santander.SantanderValidSlipPayImpl;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPay;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayParams;

public class SantanderSlipPayImpl
extends SantanderBaseConnection
implements SlipPayInterface {
    private final SlipPayConverter converter = new SantanderSlipPayConverter();
    private final SlipPayURLConverter urlConverter = new SantanderSlipPayURLImpl();
    private final SlipPayValid validator = new SantanderValidSlipPayImpl();

    @Override
    public ProcessResult<SlipPayParams, SlipPay> create(SlipPayParams params) throws BankException {
        SlipPay ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getCreateUrl(params);
            String body = this.converter.objectToText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            if (!res.isOk()) {
                return new ProcessResult<SlipPayParams, SlipPay>(res);
            }
            ret = this.converter.textToBankSlipPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            url = this.urlConverter.getConfirmUrl(params);
            body = this.converter.objectToTextConfirmation(params, params.getToken().getBankCredentials().getEnvironmentType());
            res = this.exchangePatchData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.textToBankSlipPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<SlipPayParams, SlipPay>(params, ret, res);
        }
        return new ProcessResult<SlipPayParams, SlipPay>(params, contraintValidation);
    }

    @Override
    public ProcessResult<SlipPayListParams, SlipPay> list(SlipPayListParams params) throws BankException {
        SlipPay ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToBankSlipPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<SlipPayListParams, Object>(params, ret, res);
        }
        return new ProcessResult<SlipPayListParams, SlipPay>(params, contraintValidation);
    }

    @Override
    public ProcessResult<SlipPayListAllParams, SlipPayListAll> listAll(SlipPayListAllParams params) throws BankException {
        SlipPay ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListAllUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToBankSlipPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<SlipPayListAllParams, Object>(params, ret, res);
        }
        return new ProcessResult<SlipPayListAllParams, SlipPayListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        String urlConfig = this.urlConverter.getAuthUrl(credentials);
        return this.getToken(credentials, urlConfig);
    }
}

