/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.slip.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.payments.slip.SlipPayURLConverter;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayParams;
import com.touchcomp.basementorbanks.url.SlipPayURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Optional;

public class SantanderSlipPayURLImpl
implements SlipPayURLConverter {
    private SlipPayURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getSlipPayURL();
        }
        return new SantanderHomoURL().getSlipPayURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getCreateUrl(SlipPayParams params) {
        SlipPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getCreationUrl(), params.getWorkspaceId());
        return url;
    }

    @Override
    public String getConfirmUrl(SlipPayParams params) {
        SlipPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getConfirmUrl(), params.getWorkspaceId(), params.getSlipPaymentId());
        return url;
    }

    @Override
    public String getListUrl(SlipPayListParams params) {
        SlipPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getListUrl(), params.getWorkspaceId(), params.getSlipPaymentId());
        return url;
    }

    @Override
    public String getListAllUrl(SlipPayListAllParams params) {
        SlipPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getListAllUrl(), params.getWorkspaceId());
        url = UriComponentsBuilder.from(url).queryParamIfPresent("_limit", Optional.ofNullable(params.getLimit())).queryParamIfPresent("_offset", Optional.ofNullable(params.getOffset())).queryParamIfPresent("_sort", Optional.ofNullable(params.getSort())).queryParamIfPresent("initialDate", Optional.ofNullable(params.getInitialDate())).queryParamIfPresent("finalDate", Optional.ofNullable(params.getFinalDate())).queryParamIfPresent("status", Optional.ofNullable(params.getStatusType())).build();
        return url;
    }
}

