/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.slip.impl.santander;

import am.ik.yavi.builder.ValidatorBuilder;
import am.ik.yavi.constraint.CharSequenceConstraint;
import am.ik.yavi.constraint.DoubleConstraint;
import am.ik.yavi.constraint.EnumConstraint;
import am.ik.yavi.constraint.LocalDateConstraint;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.Validator;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.services.impl.payments.slip.SlipPayValid;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.slip.model.SlipPayParams;

public class SantanderValidSlipPayImpl
implements SlipPayValid {
    private Validator<BankToken> getTokenValidation() {
        Validator bankCredentials = ValidatorBuilder.of(BankCredentials.class).constraint(BankCredentials::getEnvironmentType, "environmentType", c -> (EnumConstraint)c.notNull()).build();
        return ValidatorBuilder.of(BankToken.class).constraint(BankToken::getToken, "token", c -> c.notBlank()).nest(BankToken::getBankCredentials, "bankCredentials", bankCredentials).build();
    }

    @Override
    public ConstraintViolations isValid(SlipPayParams params) {
        Validator payer = ValidatorBuilder.of(SlipPayParams.Payer.class).constraint(SlipPayParams.Payer::getDocumentNumber, "documentNumber", c -> (CharSequenceConstraint)c.notNull()).constraint(SlipPayParams.Payer::getDocumentType, "documentType", c -> (EnumConstraint)c.notNull()).constraint(SlipPayParams.Payer::getName, "name", c -> (CharSequenceConstraint)c.notNull()).build();
        Validator validator = ValidatorBuilder.of(SlipPayParams.class).constraint(SlipPayParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).constraint(SlipPayParams::getSlipPaymentId, "slipPaymentId", c -> (CharSequenceConstraint)c.notNull()).constraint(SlipPayParams::getPaymentValue, "paymentValue", c -> (DoubleConstraint)c.notNull()).constraint(SlipPayParams::getStatusType, "statusType", c -> (CharSequenceConstraint)c.notNull()).nest(SlipPayParams::getFinalPayer, "finalPayer", payer).constraint(SlipPayParams::getCode, "code", c -> (CharSequenceConstraint)c.notNull()).constraint(SlipPayParams::getPaymentDate, "payDay", c -> (LocalDateConstraint)c.notNull()).nest(SlipPayParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(SlipPayListParams params) {
        Validator validator = ValidatorBuilder.of(SlipPayListParams.class).constraint(SlipPayListParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).constraint(SlipPayListParams::getSlipPaymentId, "slipPaymentId", c -> (CharSequenceConstraint)c.notNull()).nest(SlipPayListParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(SlipPayListAllParams params) {
        Validator validator = ValidatorBuilder.of(SlipPayListAllParams.class).constraint(SlipPayListAllParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).nest(SlipPayListAllParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }
}

