/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.tax.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.services.impl.payments.tax.TaxPayURL;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayParams;
import com.touchcomp.basementorbanks.url.TaxPayURLInterface;
import com.touchcomp.basementorbanks.url.impl.prod.SantanderProdURL;
import com.touchcomp.basementorbanks.url.impl.tests.SantanderHomoURL;
import com.touchcomp.basementorbanks.util.UriComponentsBuilder;
import com.touchcomp.basementorbanks.util.UtilMethods;
import java.util.Optional;

public class SantanderPixPayURLImpl
implements TaxPayURL {
    private TaxPayURLInterface getUrl(EnvironmentType enviromentType) {
        if (enviromentType.equals((Object)EnvironmentType.PRODUCAO)) {
            return new SantanderProdURL().getTaxPayURL();
        }
        return new SantanderHomoURL().getTaxPayURL();
    }

    @Override
    public String getAuthUrl(BankCredentials credentials) {
        return this.getUrl(credentials.getEnvironmentType()).getAuthUrl();
    }

    @Override
    public String getCreateUrl(TaxPayParams params) {
        TaxPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getCreationTaxPay(), params.getWorkspaceId());
        return url;
    }

    @Override
    public String getConfirmUrl(TaxPayParams params) {
        TaxPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getConfirmTaxPay(), params.getWorkspaceId(), params.getTaxPaymentId());
        return url;
    }

    @Override
    public String getListUrl(TaxPayListParams params) {
        TaxPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getTaxPayList(), params.getWorkspaceId(), params.getTaxPaymentId());
        return url;
    }

    @Override
    public String getListAllUrl(TaxPayListAllParams params) {
        TaxPayURLInterface source = this.getUrl(params.getToken().getBankCredentials().getEnvironmentType());
        String url = UtilMethods.formatMessage(source.getTaxPayListAll(), params.getWorkspaceId());
        url = UriComponentsBuilder.from(url).queryParamIfPresent("_limit", Optional.ofNullable(params.getLimit())).queryParamIfPresent("_offset", Optional.ofNullable(params.getOffset())).queryParamIfPresent("_sort", Optional.ofNullable(params.getSort())).queryParamIfPresent("initialDate", Optional.ofNullable(params.getInitialDate())).queryParamIfPresent("finalDate", Optional.ofNullable(params.getFinalDate())).queryParamIfPresent("status", Optional.ofNullable(params.getStatusType())).build();
        return url;
    }
}

