/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.tax.impl.santander;

import com.touchcomp.basementorbanks.constants.EnvironmentType;
import com.touchcomp.basementorbanks.constants.StateAbbreviationType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.Pageable;
import com.touchcomp.basementorbanks.services.BankJsonConverter;
import com.touchcomp.basementorbanks.services.impl.payments.tax.TaxPayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.tax.impl.constants.TaxPayType;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPay;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayParams;
import com.touchcomp.basementorbanks.util.UtilDate;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;

public class SantanderTaxPayConv
extends BankJsonConverter
implements TaxPayConverter {
    @Override
    public TaxPayListAll textToTaxPayListAll(String json, EnvironmentType environmentType) throws BankException {
        TaxPayListAll aux = new TaxPayListAll();
        JsonNode root = this.getRoot(json);
        JsonNode pageableNode = root.findValue("_pageable");
        Integer offset = this.asInt(pageableNode, "_offset");
        Integer pageNumber = this.asInt(pageableNode, "_pageNumber");
        Integer pageElements = this.asInt(pageableNode, "_pageElements");
        Integer totalPages = this.asInt(pageableNode, "_totalPages");
        Integer totalElements = this.asInt(pageableNode, "_totalElements");
        Pageable page = new Pageable();
        page.setOffset(offset);
        page.setPageElements(pageElements);
        page.setPageNumber(pageNumber);
        page.setTotalElements(totalElements);
        page.setTotalPages(totalPages);
        aux.setPageable(page);
        List<JsonNode> content = this.asList(root, "_content");
        LinkedList<TaxPay> temp = new LinkedList<TaxPay>();
        for (JsonNode jsonNode : content) {
            temp.add(this.nodeToBankTaxPay(jsonNode));
        }
        aux.setTaxPay(temp);
        return aux;
    }

    @Override
    public TaxPay textToTaxPay(String body, EnvironmentType environmentType) throws BankException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(body);
            return this.nodeToBankTaxPay(root);
        }
        catch (IOException ex) {
            Logger.getLogger(SantanderTaxPayConv.class.getName()).log(Level.SEVERE, null, ex);
            throw new BankException(ex);
        }
    }

    @Override
    public String objectToText(TaxPayParams params, EnvironmentType environmentType) throws BankException {
        TaxPayType type = params.getTaxType();
        switch (type) {
            case DARF: {
                return this.toDarf(params);
            }
            case GARE: {
                return this.toGare(params);
            }
            case GPS: {
                return this.toGps(params);
            }
        }
        throw new BankException("E.BANK.000016");
    }

    @Override
    public String objectToTextConfirm(TaxPayParams vo, EnvironmentType environmentType) throws BankException {
        JSONObject root = new JSONObject();
        root.put("status", (Object)vo.getStatusType());
        if (vo.getDebitAccount() != null) {
            JSONObject deb = new JSONObject();
            deb.put("branch", (Object)vo.getDebitAccount().getBranch());
            deb.put("number", (Object)vo.getDebitAccount().getNumber());
            root.put("debitAccount", (Object)deb);
        }
        return root.toString();
    }

    private String toDarf(TaxPayParams vo) {
        JSONObject root = new JSONObject();
        root.put("id", (Object)vo.getTaxPaymentId());
        root.put("taxType", (Object)"DARF");
        root.put("field01", (Object)vo.getPayer().getName());
        root.put("field02", (Object)UtilDate.dateToStr(vo.getAcessmentDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("field03", (Object)vo.getPayer().getDocumentNumber());
        if (vo.getPayer().getStateAbbreviation() != null) {
            root.put("stateAbbreviation", (Object)vo.getPayer().getStateAbbreviation().getValue());
        }
        root.put("city", (Object)vo.getPayer().getCity());
        root.put("field04", (Object)vo.getTaxCode());
        root.put("field05", (Object)vo.getTaxReferenceNumber());
        root.put("field06", (Object)UtilDate.dateToStr(vo.getDueDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("paymentDate", (Object)UtilDate.dateToStr(vo.getPayDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("field07", (Object)vo.getValues().getMainValue());
        root.put("field08", (Object)vo.getValues().getFine());
        root.put("field09", (Object)vo.getValues().getInterests());
        root.put("field09", (Object)vo.getValues().getInterests());
        root.put("tags", vo.getTags());
        return root.toString();
    }

    private String toGare(TaxPayParams vo) {
        JSONObject root = new JSONObject();
        root.put("id", (Object)vo.getTaxPaymentId());
        root.put("taxType", (Object)"GARE");
        root.put("city", (Object)vo.getPayer().getCity());
        if (vo.getPayer().getStateAbbreviation() != null) {
            root.put("stateAbbreviation", (Object)vo.getPayer().getStateAbbreviation().getValue());
        }
        root.put("paymentDate", (Object)UtilDate.dateToStr(vo.getPayDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("field02", (Object)UtilDate.dateToStr(vo.getDueDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("field03", (Object)vo.getTaxCode());
        root.put("field04", (Object)vo.getPayer().getStateDocumentNumber());
        root.put("field05", (Object)vo.getPayer().getDocumentNumber());
        root.put("field06", (Object)vo.getProcessNumber());
        root.put("field07", (Object)UtilDate.dateToStr(vo.getAcessmentDate(), UtilDate.Mask.TRACE_PERIOD_FORMATTER));
        root.put("field09", (Object)vo.getValues().getMainValue());
        root.put("field10", (Object)vo.getValues().getInterests());
        root.put("field11", (Object)vo.getValues().getFine());
        root.put("field12", (Object)vo.getValues().getFinancialAccrual());
        root.put("field13", (Object)vo.getValues().getAttorneysFee());
        root.put("field15", (Object)vo.getPayer().getName());
        root.put("field16", (Object)vo.getPayer().getAddress());
        root.put("field17", (Object)vo.getPayer().getPhone());
        root.put("field18", (Object)vo.getPayer().getActivitiesTaxCode());
        root.put("field19", (Object)vo.getDescription());
        root.put("tags", vo.getTags());
        return root.toString();
    }

    private String toGps(TaxPayParams vo) {
        JSONObject root = new JSONObject();
        root.put("id", (Object)vo.getTaxPaymentId());
        root.put("taxType", (Object)"GPS");
        root.put("city", (Object)vo.getPayer().getCity());
        root.put("stateAbbreviation", (Object)vo.getPayer().getStateAbbreviation().getValue());
        root.put("paymentDate", (Object)UtilDate.dateToStr(vo.getPayDate(), UtilDate.Mask.TRACE_FORMATTER));
        root.put("field01", (Object)vo.getPayer().getName());
        root.put("field03", (Object)vo.getTaxCode());
        root.put("field04", (Object)UtilDate.dateToStr(vo.getAcessmentDate(), UtilDate.Mask.TRACE_PERIOD_FORMATTER));
        root.put("field05", (Object)vo.getPayer().getDocumentNumber());
        root.put("field06", (Object)vo.getValues().getMainValue());
        root.put("field09", (Object)vo.getValues().getOtherValues());
        root.put("field10", vo.getValues().getInterests() + vo.getValues().getFine());
        root.put("tags", vo.getTags());
        return root.toString();
    }

    private TaxPay nodeToBankTaxPay(JsonNode root) throws BankException {
        String taxDescription = this.asText(root, "taxDescription");
        if (taxDescription.contains(TaxPayType.DARF.getValue())) {
            TaxPay tax = this.nodeToDarf(root);
            tax.setTaxType(TaxPayType.DARF);
            return tax;
        }
        if (taxDescription.contains(TaxPayType.GPS.getValue())) {
            TaxPay tax = this.nodeToGps(root);
            tax.setTaxType(TaxPayType.GPS);
            return tax;
        }
        if (taxDescription.contains(TaxPayType.GARE.getValue())) {
            TaxPay tax = this.nodeToGare(root);
            tax.setTaxType(TaxPayType.GARE);
            return tax;
        }
        throw new BankException("E.BANK.000016");
    }

    private TaxPay nodeToDarf(JsonNode root) {
        JsonNode transactionNode = root.get("transaction");
        JsonNode debitAccountNode = root.get("debitAccount");
        TaxPay tax = new TaxPay();
        tax.setTaxPaymentId(this.asText(root, "id"));
        tax.setAcessmentDate(this.asLocalDate(root, "field02", UtilDate.Mask.TRACE_FORMATTER));
        tax.setPaymentDate(this.asLocalDate(root, "paymentDate", UtilDate.Mask.TRACE_FORMATTER));
        tax.setPaymentValue(this.asDouble(root, "paymentValue"));
        tax.setTaxReferenceNumber(this.asText(root, "field03"));
        tax.setDueDate(this.asLocalDate(root, "field06", UtilDate.Mask.TRACE_FORMATTER));
        tax.setWorkspaceId(this.asText(root, "workspaceId"));
        tax.setDescription(this.asText(root, "taxDescription"));
        tax.setTaxCode(this.asText(root, "field04"));
        tax.setStatus(this.asText(root, "status"));
        tax.setTaxReferenceNumber(this.asText(root, "field05"));
        tax.setRejectReason(this.asText(root, "rejectReason"));
        TaxPay.Payer payer = new TaxPay.Payer();
        payer.setCity(this.asText(root, "city"));
        payer.setState(StateAbbreviationType.get(this.asText(root, "stateAbbreviation")));
        payer.setName(this.asText(root, "field01"));
        payer.setDocumentNumber(this.asText(root, "field03"));
        tax.setPayer(payer);
        TaxPay.Value values = new TaxPay.Value();
        values.setMainValue(this.asDouble(root, "field07"));
        values.setFine(this.asDouble(root, "field08"));
        values.setInterests(this.asDouble(root, "field09"));
        tax.setValues(values);
        if (transactionNode != null) {
            Double value = this.asDouble(transactionNode, "value");
            String code = this.asText(transactionNode, "code");
            LocalDateTime date = this.asLocalDateTime(transactionNode, "date");
            TaxPay.Transaction transaction = new TaxPay.Transaction();
            transaction.setPaymentValue(value);
            transaction.setTransactionCode(code);
            transaction.setTransactionDate(date);
            tax.setTransacion(transaction);
        }
        if (debitAccountNode != null) {
            String branch = this.asText(debitAccountNode, "branch");
            String number = this.asText(debitAccountNode, "number");
            TaxPay.Account account = new TaxPay.Account();
            account.setBranch(branch);
            account.setNumber(number);
            tax.setDebitAccount(account);
        }
        return tax;
    }

    private TaxPay nodeToGare(JsonNode root) {
        JsonNode transactionNode = root.get("transaction");
        JsonNode debitAccountNode = root.get("debitAccount");
        TaxPay tax = new TaxPay();
        tax.setTaxPaymentId(this.asText(root, "id"));
        tax.setWorkspaceId(this.asText(root, "workspaceId"));
        tax.setDescription(this.asText(root, "taxDescription"));
        tax.setTaxCode(this.asText(root, "field03"));
        tax.setAcessmentDate(this.asLocalDate(root, "accountingDate", UtilDate.Mask.TRACE_FORMATTER));
        tax.setDueDate(this.asLocalDate(root, "field02", UtilDate.Mask.TRACE_FORMATTER));
        tax.setStatus(this.asText(root, "status"));
        tax.setRejectReason(this.asText(root, "rejectReason"));
        tax.setNotes(this.asText(root, "field19"));
        tax.setPaymentValue(this.asDouble(root, "paymentValue"));
        tax.setPaymentDate(this.asLocalDate(root, "paymentDate", UtilDate.Mask.TRACE_FORMATTER));
        TaxPay.Payer payer = new TaxPay.Payer();
        payer.setCity(this.asText(root, "city"));
        payer.setState(StateAbbreviationType.get(this.asText(root, "stateAbbreviation")));
        payer.setName(this.asText(root, "field15"));
        payer.setAddress(this.asText(root, "field16"));
        payer.setDocumentNumber(this.asText(root, "field05"));
        payer.setPhone(this.asText(root, "field17"));
        payer.setActivitiesTaxCode(this.asText(root, "field18"));
        tax.setPayer(payer);
        TaxPay.Value values = new TaxPay.Value();
        values.setMainValue(this.asDouble(root, "field09"));
        values.setFine(this.asDouble(root, "field11"));
        values.setFinancialAccrual(this.asDouble(root, "field12"));
        values.setAttorneysFee(this.asDouble(root, "field12"));
        values.setInterests(this.asDouble(root, "field10"));
        tax.setValues(values);
        if (transactionNode != null) {
            TaxPay.Transaction transaction = new TaxPay.Transaction();
            tax.setTransacion(transaction);
        }
        if (debitAccountNode != null) {
            String branch = this.asText(debitAccountNode, "branch");
            String number = this.asText(debitAccountNode, "number");
            TaxPay.Account account = new TaxPay.Account();
            account.setBranch(branch);
            account.setNumber(number);
            tax.setDebitAccount(account);
        }
        return tax;
    }

    private TaxPay nodeToGps(JsonNode root) {
        JsonNode transactionNode = root.get("transaction");
        JsonNode debitAccountNode = root.get("debitAccount");
        TaxPay tax = new TaxPay();
        tax.setTaxPaymentId(this.asText(root, "id"));
        tax.setWorkspaceId(this.asText(root, "workspaceId"));
        tax.setDescription(this.asText(root, "taxDescription"));
        tax.setTaxCode(this.asText(root, "field03"));
        Object strPeriod = this.asText(root, "field04");
        if (strPeriod != null && ((String)strPeriod).length() <= 7) {
            strPeriod = (String)strPeriod + "-01";
        }
        tax.setAcessmentDate(UtilDate.strToLocalDate((String)strPeriod, UtilDate.Mask.TRACE_FORMATTER));
        tax.setStatus(this.asText(root, "status"));
        tax.setRejectReason(this.asText(root, "rejectReason"));
        tax.setPaymentValue(this.asDouble(root, "paymentValue"));
        tax.setPaymentDate(this.asLocalDate(root, "paymentDate", UtilDate.Mask.TRACE_FORMATTER));
        TaxPay.Payer payer = new TaxPay.Payer();
        payer.setCity(this.asText(root, "city"));
        payer.setState(StateAbbreviationType.get(this.asText(root, "stateAbbreviation")));
        payer.setName(this.asText(root, "field01"));
        payer.setDocumentNumber(this.asText(root, "field05"));
        tax.setPayer(payer);
        TaxPay.Value values = new TaxPay.Value();
        values.setMainValue(this.asDouble(root, "field06"));
        values.setFine(this.asDouble(root, "field10"));
        values.setOtherValues(this.asDouble(root, "field09"));
        tax.setValues(values);
        if (transactionNode != null) {
            TaxPay.Transaction transaction = new TaxPay.Transaction();
            transaction.setTransactionDate(this.asLocalDateTime(root, "date"));
            transaction.setTransactionCode(this.asText(root, "code"));
            transaction.setPaymentValue(this.asDouble(root, "value"));
            tax.setTransacion(transaction);
        }
        if (debitAccountNode != null) {
            String branch = this.asText(debitAccountNode, "branch");
            String number = this.asText(debitAccountNode, "number");
            TaxPay.Account account = new TaxPay.Account();
            account.setBranch(branch);
            account.setNumber(number);
            tax.setDebitAccount(account);
        }
        return tax;
    }
}

