/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.tax.impl.santander;

import am.ik.yavi.core.ConstraintViolations;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.model.ProcessResult;
import com.touchcomp.basementorbanks.model.ResponseResult;
import com.touchcomp.basementorbanks.services.connection.SantanderBaseConnection;
import com.touchcomp.basementorbanks.services.impl.payments.tax.TaxPayConverter;
import com.touchcomp.basementorbanks.services.impl.payments.tax.TaxPayInterface;
import com.touchcomp.basementorbanks.services.impl.payments.tax.TaxPayURL;
import com.touchcomp.basementorbanks.services.impl.payments.tax.TaxPayValid;
import com.touchcomp.basementorbanks.services.impl.payments.tax.impl.santander.SantanderPixPayURLImpl;
import com.touchcomp.basementorbanks.services.impl.payments.tax.impl.santander.SantanderTaxPayConv;
import com.touchcomp.basementorbanks.services.impl.payments.tax.impl.santander.SantanderValidTaxPayImpl;
import com.touchcomp.basementorbanks.services.impl.payments.tax.impl.santander.constants.SantanderTaxPayStatusType;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPay;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayListAll;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayParams;

public class SantanderTaxPayImpl
extends SantanderBaseConnection
implements TaxPayInterface {
    private final TaxPayConverter converter = new SantanderTaxPayConv();
    private final TaxPayURL urlConverter = new SantanderPixPayURLImpl();
    private final TaxPayValid validator = new SantanderValidTaxPayImpl();

    @Override
    public ProcessResult<TaxPayParams, TaxPay> create(TaxPayParams params) throws BankException {
        TaxPay ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getCreateUrl(params);
            String body = this.converter.objectToText(params, params.getToken().getBankCredentials().getEnvironmentType());
            ResponseResult res = this.exchangePostData(params.getToken(), url, body);
            ret = this.converter.textToTaxPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            params.setStatusType(SantanderTaxPayStatusType.AUTHORIZED.getValue());
            url = this.urlConverter.getConfirmUrl(params);
            body = this.converter.objectToTextConfirm(params, params.getToken().getBankCredentials().getEnvironmentType());
            res = this.exchangePatchData(params.getToken(), url, body);
            if (res.isOk()) {
                ret = this.converter.textToTaxPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<TaxPayParams, TaxPay>(params, ret, res);
        }
        return new ProcessResult<TaxPayParams, TaxPay>(params, contraintValidation);
    }

    @Override
    public ProcessResult<TaxPayListParams, TaxPay> list(TaxPayListParams params) throws BankException {
        TaxPay ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToTaxPay(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<TaxPayListParams, Object>(params, ret, res);
        }
        return new ProcessResult<TaxPayListParams, TaxPay>(params, contraintValidation);
    }

    @Override
    public ProcessResult<TaxPayListAllParams, TaxPayListAll> listAll(TaxPayListAllParams params) throws BankException {
        TaxPayListAll ret = null;
        ConstraintViolations contraintValidation = this.validator.isValid(params);
        if (contraintValidation.isValid()) {
            String url = this.urlConverter.getListAllUrl(params);
            ResponseResult res = this.exchangeGetData(params.getToken(), url);
            if (res.isOk()) {
                ret = this.converter.textToTaxPayListAll(res.getBody(), params.getToken().getBankCredentials().getEnvironmentType());
            }
            return new ProcessResult<TaxPayListAllParams, Object>(params, ret, res);
        }
        return new ProcessResult<TaxPayListAllParams, TaxPayListAll>(params, contraintValidation);
    }

    @Override
    public ProcessResult<BankCredentials, BankToken> getToken(BankCredentials credentials) throws BankException {
        String urlConfig = this.urlConverter.getAuthUrl(credentials);
        return this.getToken(credentials, urlConfig);
    }
}

