/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.tax.impl.santander;

import am.ik.yavi.builder.ValidatorBuilder;
import am.ik.yavi.constraint.CharSequenceConstraint;
import am.ik.yavi.constraint.DoubleConstraint;
import am.ik.yavi.constraint.EnumConstraint;
import am.ik.yavi.constraint.LocalDateConstraint;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.Validator;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.services.impl.payments.tax.TaxPayValid;
import com.touchcomp.basementorbanks.services.impl.payments.tax.impl.constants.TaxPayType;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayListParams;
import com.touchcomp.basementorbanks.services.impl.payments.tax.model.TaxPayParams;
import java.util.Objects;

public class SantanderValidTaxPayImpl
implements TaxPayValid {
    private Validator<BankToken> getTokenValidation() {
        Validator bankCredentials = ValidatorBuilder.of(BankCredentials.class).constraint(BankCredentials::getEnvironmentType, "environmentType", c -> (EnumConstraint)c.notNull()).build();
        return ValidatorBuilder.of(BankToken.class).constraint(BankToken::getToken, "token", c -> c.notBlank()).nest(BankToken::getBankCredentials, "bankCredentials", bankCredentials).build();
    }

    @Override
    public ConstraintViolations isValid(TaxPayParams params) {
        ValidatorBuilder values;
        ValidatorBuilder payer;
        ValidatorBuilder validator = ValidatorBuilder.of(TaxPayParams.class).constraint(TaxPayParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).constraint(TaxPayParams::getTaxCode, "taxCode", c -> (CharSequenceConstraint)c.notNull()).constraint(TaxPayParams::getTaxType, "taxType", c -> (EnumConstraint)c.notNull()).constraint(TaxPayParams::getTaxPaymentId, "taxId", c -> (CharSequenceConstraint)c.notNull()).nest(TaxPayParams::getToken, "bankToken", this.getTokenValidation());
        if (Objects.equals((Object)params.getTaxType(), (Object)TaxPayType.GPS)) {
            validator.constraint(TaxPayParams::getAcessmentDate, "acessmentDate", c -> (LocalDateConstraint)c.notNull());
            payer = ValidatorBuilder.of(TaxPayParams.Payer.class).constraint(TaxPayParams.Payer::getDocumentNumber, "documentNumber", c -> (CharSequenceConstraint)c.notNull());
            validator.nest(TaxPayParams::getPayer, "payer", payer.build());
            values = ValidatorBuilder.of(TaxPayParams.Value.class).constraint(TaxPayParams.Value::getMainValue, "mainValue", c -> (DoubleConstraint)c.notNull());
            validator.nest(TaxPayParams::getValues, "values", values.build());
        } else if (Objects.equals((Object)params.getTaxType(), (Object)TaxPayType.GARE)) {
            validator.constraint(TaxPayParams::getAcessmentDate, "acessmentDate", c -> (LocalDateConstraint)c.notNull());
            payer = ValidatorBuilder.of(TaxPayParams.Payer.class).constraint(TaxPayParams.Payer::getDocumentNumber, "documentNumber", c -> (CharSequenceConstraint)c.notNull());
            validator.nest(TaxPayParams::getPayer, "payer", payer.build());
            values = ValidatorBuilder.of(TaxPayParams.Value.class).constraint(TaxPayParams.Value::getMainValue, "mainValue", c -> (DoubleConstraint)c.notNull());
            validator.nest(TaxPayParams::getValues, "values", values.build());
        }
        if (Objects.equals((Object)params.getTaxType(), (Object)TaxPayType.DARF)) {
            validator.constraint(TaxPayParams::getAcessmentDate, "acessmentDate", c -> (LocalDateConstraint)c.notNull());
            validator.constraint(TaxPayParams::getDueDate, "dueDate", c -> (LocalDateConstraint)c.notNull());
            payer = ValidatorBuilder.of(TaxPayParams.Payer.class).constraint(TaxPayParams.Payer::getDocumentNumber, "documentNumber", c -> (CharSequenceConstraint)c.notNull());
            validator.nest(TaxPayParams::getPayer, "payer", payer.build());
            values = ValidatorBuilder.of(TaxPayParams.Value.class).constraint(TaxPayParams.Value::getMainValue, "mainValue", c -> (DoubleConstraint)c.notNull());
            validator.nest(TaxPayParams::getValues, "values", values.build());
        }
        return validator.build().validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(TaxPayListParams params) {
        Validator validator = ValidatorBuilder.of(TaxPayListParams.class).constraint(TaxPayListParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).constraint(TaxPayListParams::getTaxPaymentId, "slipPaymentId", c -> (CharSequenceConstraint)c.notNull()).nest(TaxPayListParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(TaxPayListAllParams params) {
        Validator validator = ValidatorBuilder.of(TaxPayListAllParams.class).constraint(TaxPayListAllParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).nest(TaxPayListAllParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }
}

