/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.services.impl.payments.vehicles.impl.santander;

import am.ik.yavi.builder.ValidatorBuilder;
import am.ik.yavi.constraint.CharSequenceConstraint;
import am.ik.yavi.constraint.EnumConstraint;
import am.ik.yavi.constraint.IntegerConstraint;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.Validator;
import com.touchcomp.basementorbanks.model.BankCredentials;
import com.touchcomp.basementorbanks.model.BankToken;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.VehiclesTaxValid;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxDebitsParams;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxListAllParams;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxListParams;
import com.touchcomp.basementorbanks.services.impl.payments.vehicles.model.VehiclesTaxParams;

public class SantanderValidVehiclesImpl
implements VehiclesTaxValid {
    private Validator<BankToken> getTokenValidation() {
        Validator bankCredentials = ValidatorBuilder.of(BankCredentials.class).constraint(BankCredentials::getEnvironmentType, "environmentType", c -> (EnumConstraint)c.notNull()).build();
        return ValidatorBuilder.of(BankToken.class).constraint(BankToken::getToken, "token", c -> c.notBlank()).nest(BankToken::getBankCredentials, "bankCredentials", bankCredentials).build();
    }

    @Override
    public ConstraintViolations isValid(VehiclesTaxParams params) {
        Validator validator = ValidatorBuilder.of(VehiclesTaxParams.class).constraint(VehiclesTaxParams::getExerciseYear, "exerciseYear", c -> (IntegerConstraint)c.notNull()).constraint(VehiclesTaxParams::getRenavam, "renavam", c -> (CharSequenceConstraint)c.notNull()).constraint(VehiclesTaxParams::getTaxType, "taxType", c -> (EnumConstraint)c.notNull()).constraint(VehiclesTaxParams::getStateType, "state", c -> (EnumConstraint)c.notNull()).constraint(VehiclesTaxParams::getQuotaType, "quota", c -> (EnumConstraint)c.notNull()).nest(VehiclesTaxParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(VehiclesTaxListParams params) {
        Validator validator = ValidatorBuilder.of(VehiclesTaxListParams.class).constraint(VehiclesTaxListParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).constraint(VehiclesTaxListParams::getVehiclesTaxPaymentId, "vehiclesTaxPaymentId", c -> (CharSequenceConstraint)c.notNull()).nest(VehiclesTaxListParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(VehiclesTaxListAllParams params) {
        Validator validator = ValidatorBuilder.of(VehiclesTaxListAllParams.class).constraint(VehiclesTaxListAllParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).nest(VehiclesTaxListAllParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }

    @Override
    public ConstraintViolations isValid(VehiclesTaxDebitsParams params) {
        Validator validator = ValidatorBuilder.of(VehiclesTaxDebitsParams.class).constraint(VehiclesTaxDebitsParams::getWorkspaceId, "workspaceId", c -> (CharSequenceConstraint)c.notNull()).constraint(VehiclesTaxDebitsParams::getRenavam, "renavam", c -> (CharSequenceConstraint)c.notNull()).constraint(VehiclesTaxDebitsParams::getStateAbbreviation, "stateAbbreviation", c -> (EnumConstraint)c.notNull()).nest(VehiclesTaxDebitsParams::getToken, "bankToken", this.getTokenValidation()).build();
        return validator.validate((Object)params);
    }
}

